/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.convert.BinderConversionService;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;

class MapBinder
extends AggregateBinder<Map<Object, Object>> {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);

    MapBinder(BindContext context) {
        super(context);
    }

    @Override
    protected Object bind(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder, Class<?> type) {
        Map map = CollectionFactory.createMap(type, (int)0);
        Bindable<?> resolvedTarget = this.resolveTarget(target);
        for (ConfigurationPropertySource source : this.getContext().getSources()) {
            if (!ConfigurationPropertyName.EMPTY.equals(name)) {
                source = source.filter(name::isAncestorOf);
            }
            new EntryBinder(name, resolvedTarget, elementBinder).bindEntries(source, map);
        }
        return map.isEmpty() ? null : map;
    }

    private Bindable<?> resolveTarget(Bindable<?> target) {
        Class type = target.getType().resolve();
        if (Properties.class.isAssignableFrom(type)) {
            return STRING_STRING_MAP;
        }
        return target;
    }

    @Override
    protected Map<Object, Object> merge(Map<Object, Object> existing, Map<Object, Object> additional) {
        existing.putAll(additional);
        return existing;
    }

    private class EntryBinder {
        private final ConfigurationPropertyName root;
        private final AggregateElementBinder elementBinder;
        private final ResolvableType mapType;
        private final ResolvableType keyType;
        private final ResolvableType valueType;

        EntryBinder(ConfigurationPropertyName root, Bindable<?> target, AggregateElementBinder elementBinder) {
            this.root = root;
            this.elementBinder = elementBinder;
            this.mapType = target.getType().asMap();
            this.keyType = this.mapType.getGeneric(new int[]{0});
            this.valueType = this.mapType.getGeneric(new int[]{1});
        }

        public void bindEntries(ConfigurationPropertySource source, Map<Object, Object> map) {
            if (source instanceof IterableConfigurationPropertySource) {
                for (ConfigurationPropertyName name : (IterableConfigurationPropertySource)source) {
                    Bindable<?> valueBindable = this.getValueBindable(name);
                    ConfigurationPropertyName entryName = this.getEntryName(source, name);
                    Object key = MapBinder.this.getContext().getConversionService().convert((Object)this.getKeyName(entryName), this.keyType);
                    map.computeIfAbsent(key, k -> this.elementBinder.bind(entryName, valueBindable));
                }
            }
        }

        private Bindable<?> getValueBindable(ConfigurationPropertyName name) {
            if (!this.root.isParentOf(name) && this.isValueTreatedAsNestedMap()) {
                return Bindable.of(this.mapType);
            }
            return Bindable.of(this.valueType);
        }

        private ConfigurationPropertyName getEntryName(ConfigurationPropertySource source, ConfigurationPropertyName name) {
            Class resolved = this.valueType.resolve();
            if (Collection.class.isAssignableFrom(resolved) || this.valueType.isArray()) {
                return this.chopNameAtNumericIndex(name);
            }
            if (!(this.root.isParentOf(name) || !this.isValueTreatedAsNestedMap() && this.isScalarValue(source, name))) {
                return name.chop(this.root.getNumberOfElements() + 1);
            }
            return name;
        }

        private ConfigurationPropertyName chopNameAtNumericIndex(ConfigurationPropertyName name) {
            int start = this.root.getNumberOfElements() + 1;
            int size = name.getNumberOfElements();
            for (int i = start; i < size; ++i) {
                if (!name.isNumericIndex(i)) continue;
                return name.chop(i);
            }
            return name;
        }

        private boolean isValueTreatedAsNestedMap() {
            return Object.class.equals((Object)this.valueType.resolve(Object.class));
        }

        private boolean isScalarValue(ConfigurationPropertySource source, ConfigurationPropertyName name) {
            Class resolved = this.valueType.resolve();
            String packageName = ClassUtils.getPackageName((Class)resolved);
            if (!packageName.startsWith("java.lang") && !resolved.isEnum()) {
                return false;
            }
            ConfigurationProperty property = source.getConfigurationProperty(name);
            if (property == null) {
                return false;
            }
            Object value = property.getValue();
            value = MapBinder.this.getContext().getPlaceholdersResolver().resolvePlaceholders(value);
            BinderConversionService conversionService = MapBinder.this.getContext().getConversionService();
            return conversionService.canConvert(value, this.valueType);
        }

        private String getKeyName(ConfigurationPropertyName name) {
            StringBuilder result = new StringBuilder();
            for (int i = this.root.getNumberOfElements(); i < name.getNumberOfElements(); ++i) {
                result.append(result.length() == 0 ? "" : ".");
                result.append(name.getElement(i, ConfigurationPropertyName.Form.ORIGINAL));
            }
            return result.toString();
        }
    }
}

