/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.OriginTrackedPropertiesLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PropertiesPropertySourceLoader
implements PropertySourceLoader {
    private static final String XML_FILE_EXTENSION = ".xml";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"properties", "xml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profileToLoad, Predicate<String[]> acceptsProfiles) throws IOException {
        Map<String, ?> properties;
        if (profileToLoad == null && !(properties = this.loadProperties(resource)).isEmpty()) {
            return new OriginTrackedMapPropertySource(name, properties);
        }
        return null;
    }

    private Map<String, ?> loadProperties(Resource resource) throws IOException {
        String filename = resource.getFilename();
        if (filename != null && filename.endsWith(XML_FILE_EXTENSION)) {
            return PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        return new OriginTrackedPropertiesLoader(resource).load();
    }
}

