/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.embedded.netty.NettyWebServer;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.ipc.netty.http.server.HttpServer;
import reactor.ipc.netty.http.server.HttpServerOptions;

public class NettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private List<NettyServerCustomizer> serverCustomizers = new ArrayList<NettyServerCustomizer>();
    private Duration lifecycleTimeout;

    public NettyReactiveWebServerFactory() {
    }

    public NettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServer httpServer = this.createHttpServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        return new NettyWebServer(httpServer, handlerAdapter, this.lifecycleTimeout);
    }

    public Collection<NettyServerCustomizer> getServerCustomizers() {
        return this.serverCustomizers;
    }

    public void setServerCustomizers(Collection<? extends NettyServerCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, (String)"ServerCustomizers must not be null");
        this.serverCustomizers = new ArrayList<NettyServerCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(NettyServerCustomizer ... serverCustomizers) {
        Assert.notNull((Object)serverCustomizers, (String)"ServerCustomizer must not be null");
        this.serverCustomizers.addAll(Arrays.asList(serverCustomizers));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    private HttpServer createHttpServer() {
        return HttpServer.builder().options(options -> {
            options.listenAddress((SocketAddress)this.getListenAddress());
            if (this.getSsl() != null && this.getSsl().isEnabled()) {
                SslServerCustomizer sslServerCustomizer = new SslServerCustomizer(this.getSsl(), this.getSslStoreProvider());
                sslServerCustomizer.customize((HttpServerOptions.Builder)options);
            }
            if (this.getCompression() != null && this.getCompression().getEnabled()) {
                options.compression(this.getCompression().getMinResponseSize());
            }
            this.applyCustomizers((HttpServerOptions.Builder)options);
        }).build();
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private void applyCustomizers(HttpServerOptions.Builder options) {
        this.serverCustomizers.forEach(customizer -> customizer.customize(options));
    }
}

