/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.TaskExecutorCustomizer;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TaskExecutorBuilder {
    private final Integer queueCapacity;
    private final Integer corePoolSize;
    private final Integer maxPoolSize;
    private final Boolean allowCoreThreadTimeOut;
    private final Duration keepAlive;
    private final String threadNamePrefix;
    private final TaskDecorator taskDecorator;
    private final Set<TaskExecutorCustomizer> taskExecutorCustomizers;

    public TaskExecutorBuilder(TaskExecutorCustomizer ... taskExecutorCustomizers) {
        Assert.notNull((Object)taskExecutorCustomizers, (String)"TaskExecutorCustomizers must not be null");
        this.queueCapacity = null;
        this.corePoolSize = null;
        this.maxPoolSize = null;
        this.allowCoreThreadTimeOut = null;
        this.keepAlive = null;
        this.threadNamePrefix = null;
        this.taskDecorator = null;
        this.taskExecutorCustomizers = Collections.unmodifiableSet(new LinkedHashSet<TaskExecutorCustomizer>(Arrays.asList(taskExecutorCustomizers)));
    }

    public TaskExecutorBuilder(Integer queueCapacity, Integer corePoolSize, Integer maxPoolSize, Boolean allowCoreThreadTimeOut, Duration keepAlive, String threadNamePrefix, TaskDecorator taskDecorator, Set<TaskExecutorCustomizer> taskExecutorCustomizers) {
        this.queueCapacity = queueCapacity;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        this.keepAlive = keepAlive;
        this.threadNamePrefix = threadNamePrefix;
        this.taskDecorator = taskDecorator;
        this.taskExecutorCustomizers = taskExecutorCustomizers;
    }

    public TaskExecutorBuilder queueCapacity(int queueCapacity) {
        return new TaskExecutorBuilder(queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder corePoolSize(int corePoolSize) {
        return new TaskExecutorBuilder(this.queueCapacity, corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder maxPoolSize(int maxPoolSize) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder keepAlive(Duration keepAlive) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, keepAlive, this.threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder threadNamePrefix(String threadNamePrefix) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, threadNamePrefix, this.taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder taskDecorator(TaskDecorator taskDecorator) {
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, taskDecorator, this.taskExecutorCustomizers);
    }

    public TaskExecutorBuilder customizers(TaskExecutorCustomizer ... taskExecutorCustomizers) {
        Assert.notNull((Object)taskExecutorCustomizers, (String)"TaskExecutorCustomizers must not be null");
        return this.customizers(Arrays.asList(taskExecutorCustomizers));
    }

    public TaskExecutorBuilder customizers(Collection<? extends TaskExecutorCustomizer> taskExecutorCustomizers) {
        Assert.notNull(taskExecutorCustomizers, (String)"TaskExecutorCustomizers must not be null");
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, Collections.unmodifiableSet(new LinkedHashSet<TaskExecutorCustomizer>(taskExecutorCustomizers)));
    }

    public TaskExecutorBuilder additionalCustomizers(TaskExecutorCustomizer ... taskExecutorCustomizers) {
        Assert.notNull((Object)taskExecutorCustomizers, (String)"TaskExecutorCustomizers must not be null");
        return this.additionalCustomizers(Arrays.asList(taskExecutorCustomizers));
    }

    public TaskExecutorBuilder additionalCustomizers(Collection<? extends TaskExecutorCustomizer> taskExecutorCustomizers) {
        Assert.notNull(taskExecutorCustomizers, (String)"TaskExecutorCustomizers must not be null");
        return new TaskExecutorBuilder(this.queueCapacity, this.corePoolSize, this.maxPoolSize, this.allowCoreThreadTimeOut, this.keepAlive, this.threadNamePrefix, this.taskDecorator, TaskExecutorBuilder.append(this.taskExecutorCustomizers, taskExecutorCustomizers));
    }

    public ThreadPoolTaskExecutor build() {
        return this.build(ThreadPoolTaskExecutor.class);
    }

    public <T extends ThreadPoolTaskExecutor> T build(Class<T> taskExecutorClass) {
        return (T)this.configure((ThreadPoolTaskExecutor)BeanUtils.instantiateClass(taskExecutorClass));
    }

    public <T extends ThreadPoolTaskExecutor> T configure(T taskExecutor) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> this.queueCapacity).to(arg_0 -> taskExecutor.setQueueCapacity(arg_0));
        map.from(() -> this.corePoolSize).to(arg_0 -> taskExecutor.setCorePoolSize(arg_0));
        map.from(() -> this.maxPoolSize).to(arg_0 -> taskExecutor.setMaxPoolSize(arg_0));
        map.from(() -> this.keepAlive).asInt(Duration::getSeconds).to(arg_0 -> taskExecutor.setKeepAliveSeconds(arg_0));
        map.from(() -> this.allowCoreThreadTimeOut).to(arg_0 -> taskExecutor.setAllowCoreThreadTimeOut(arg_0));
        map.from(() -> this.threadNamePrefix).whenHasText().to(arg_0 -> taskExecutor.setThreadNamePrefix(arg_0));
        map.from(() -> this.taskDecorator).to(arg_0 -> taskExecutor.setTaskDecorator(arg_0));
        if (!CollectionUtils.isEmpty(this.taskExecutorCustomizers)) {
            for (TaskExecutorCustomizer customizer : this.taskExecutorCustomizers) {
                customizer.customize(taskExecutor);
            }
        }
        return taskExecutor;
    }

    private static <T> Set<T> append(Set<T> set, Collection<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set != null ? set : Collections.emptySet());
        result.addAll(additions);
        return Collections.unmodifiableSet(result);
    }
}

