/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.TaskSchedulerCustomizer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TaskSchedulerBuilder {
    private final Integer poolSize;
    private final String threadNamePrefix;
    private final Set<TaskSchedulerCustomizer> taskSchedulerCustomizers;

    public TaskSchedulerBuilder(TaskSchedulerCustomizer ... taskSchedulerCustomizers) {
        Assert.notNull((Object)taskSchedulerCustomizers, (String)"TaskSchedulerCustomizers must not be null");
        this.poolSize = null;
        this.threadNamePrefix = null;
        this.taskSchedulerCustomizers = Collections.unmodifiableSet(new LinkedHashSet<TaskSchedulerCustomizer>(Arrays.asList(taskSchedulerCustomizers)));
    }

    public TaskSchedulerBuilder(Integer poolSize, String threadNamePrefix, Set<TaskSchedulerCustomizer> taskSchedulerCustomizers) {
        this.poolSize = poolSize;
        this.threadNamePrefix = threadNamePrefix;
        this.taskSchedulerCustomizers = taskSchedulerCustomizers;
    }

    public TaskSchedulerBuilder poolSize(int poolSize) {
        return new TaskSchedulerBuilder(poolSize, this.threadNamePrefix, this.taskSchedulerCustomizers);
    }

    public TaskSchedulerBuilder threadNamePrefix(String threadNamePrefix) {
        return new TaskSchedulerBuilder(this.poolSize, threadNamePrefix, this.taskSchedulerCustomizers);
    }

    public TaskSchedulerBuilder customizers(TaskSchedulerCustomizer ... taskSchedulerCustomizers) {
        Assert.notNull((Object)taskSchedulerCustomizers, (String)"TaskSchedulerCustomizers must not be null");
        return this.customizers(Arrays.asList(taskSchedulerCustomizers));
    }

    public TaskSchedulerBuilder customizers(Collection<? extends TaskSchedulerCustomizer> taskSchedulerCustomizers) {
        Assert.notNull(taskSchedulerCustomizers, (String)"TaskSchedulerCustomizers must not be null");
        return new TaskSchedulerBuilder(this.poolSize, this.threadNamePrefix, Collections.unmodifiableSet(new LinkedHashSet<TaskSchedulerCustomizer>(taskSchedulerCustomizers)));
    }

    public TaskSchedulerBuilder additionalCustomizers(TaskSchedulerCustomizer ... taskSchedulerCustomizers) {
        Assert.notNull((Object)taskSchedulerCustomizers, (String)"TaskSchedulerCustomizers must not be null");
        return this.additionalCustomizers(Arrays.asList(taskSchedulerCustomizers));
    }

    public TaskSchedulerBuilder additionalCustomizers(Collection<? extends TaskSchedulerCustomizer> taskSchedulerCustomizers) {
        Assert.notNull(taskSchedulerCustomizers, (String)"TaskSchedulerCustomizers must not be null");
        return new TaskSchedulerBuilder(this.poolSize, this.threadNamePrefix, TaskSchedulerBuilder.append(this.taskSchedulerCustomizers, taskSchedulerCustomizers));
    }

    public ThreadPoolTaskScheduler build() {
        return this.configure(new ThreadPoolTaskScheduler());
    }

    public <T extends ThreadPoolTaskScheduler> T configure(T taskScheduler) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(() -> this.poolSize).to(arg_0 -> taskScheduler.setPoolSize(arg_0));
        map.from(() -> this.threadNamePrefix).to(arg_0 -> taskScheduler.setThreadNamePrefix(arg_0));
        if (!CollectionUtils.isEmpty(this.taskSchedulerCustomizers)) {
            for (TaskSchedulerCustomizer customizer : this.taskSchedulerCustomizers) {
                customizer.customize(taskScheduler);
            }
        }
        return taskScheduler;
    }

    private static <T> Set<T> append(Set<T> set, Collection<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set != null ? set : Collections.emptySet());
        result.addAll(additions);
        return Collections.unmodifiableSet(result);
    }
}

