/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.Arrays;
import java.util.function.BiPredicate;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

final class CompressionCustomizer
implements NettyServerCustomizer {
    private static final CompressionPredicate ALWAYS_COMPRESS = (request, response) -> true;
    private final Compression compression;

    CompressionCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public HttpServer apply(HttpServer server) {
        if (this.compression.getMinResponseSize() >= 0) {
            server = server.compress(this.compression.getMinResponseSize());
        }
        CompressionPredicate mimeTypes = this.getMimeTypesPredicate(this.compression.getMimeTypes());
        CompressionPredicate excludedUserAgents = this.getExcludedUserAgentsPredicate(this.compression.getExcludedUserAgents());
        server = server.compress(mimeTypes.and(excludedUserAgents));
        return server;
    }

    private CompressionPredicate getMimeTypesPredicate(String[] mimeTypes) {
        if (ObjectUtils.isEmpty((Object[])mimeTypes)) {
            return ALWAYS_COMPRESS;
        }
        return (request, response) -> {
            String contentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (StringUtils.isEmpty((Object)contentType)) {
                return false;
            }
            MimeType contentMimeType = MimeTypeUtils.parseMimeType((String)contentType);
            return Arrays.stream(mimeTypes).map(MimeTypeUtils::parseMimeType).anyMatch(candidate -> candidate.isCompatibleWith(contentMimeType));
        };
    }

    private CompressionPredicate getExcludedUserAgentsPredicate(String[] excludedUserAgents) {
        if (ObjectUtils.isEmpty((Object[])excludedUserAgents)) {
            return ALWAYS_COMPRESS;
        }
        return (request, response) -> {
            HttpHeaders headers = request.requestHeaders();
            return Arrays.stream(excludedUserAgents).noneMatch(candidate -> headers.contains((CharSequence)HttpHeaderNames.USER_AGENT, (CharSequence)candidate, true));
        };
    }

    private static interface CompressionPredicate
    extends BiPredicate<HttpServerRequest, HttpServerResponse> {
    }
}

