/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.web.embedded.netty.CompressionCustomizer;
import org.springframework.boot.web.embedded.netty.NettyServerCustomizer;
import org.springframework.boot.web.embedded.netty.NettyWebServer;
import org.springframework.boot.web.embedded.netty.SslServerCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorHttpHandlerAdapter;
import org.springframework.util.Assert;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.server.HttpServer;

public class NettyReactiveWebServerFactory
extends AbstractReactiveWebServerFactory {
    private List<NettyServerCustomizer> serverCustomizers = new ArrayList<NettyServerCustomizer>();
    private Duration lifecycleTimeout;
    private boolean useForwardHeaders;

    public NettyReactiveWebServerFactory() {
    }

    public NettyReactiveWebServerFactory(int port) {
        super(port);
    }

    @Override
    public WebServer getWebServer(HttpHandler httpHandler) {
        HttpServer httpServer = this.createHttpServer();
        ReactorHttpHandlerAdapter handlerAdapter = new ReactorHttpHandlerAdapter(httpHandler);
        return new NettyWebServer(httpServer, handlerAdapter, this.lifecycleTimeout);
    }

    public Collection<NettyServerCustomizer> getServerCustomizers() {
        return this.serverCustomizers;
    }

    public void setServerCustomizers(Collection<? extends NettyServerCustomizer> serverCustomizers) {
        Assert.notNull(serverCustomizers, (String)"ServerCustomizers must not be null");
        this.serverCustomizers = new ArrayList<NettyServerCustomizer>(serverCustomizers);
    }

    public void addServerCustomizers(NettyServerCustomizer ... serverCustomizers) {
        Assert.notNull((Object)serverCustomizers, (String)"ServerCustomizer must not be null");
        this.serverCustomizers.addAll(Arrays.asList(serverCustomizers));
    }

    public void setLifecycleTimeout(Duration lifecycleTimeout) {
        this.lifecycleTimeout = lifecycleTimeout;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    private HttpServer createHttpServer() {
        HttpServer server = HttpServer.create().tcpConfiguration(tcpServer -> tcpServer.addressSupplier(this::getListenAddress));
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            SslServerCustomizer sslServerCustomizer = new SslServerCustomizer(this.getSsl(), this.getHttp2(), this.getSslStoreProvider());
            server = sslServerCustomizer.apply(server);
        }
        if (this.getCompression() != null && this.getCompression().getEnabled()) {
            CompressionCustomizer compressionCustomizer = new CompressionCustomizer(this.getCompression());
            server = compressionCustomizer.apply(server);
        }
        server = server.protocol(this.listProtocols());
        server = this.useForwardHeaders ? server.forwarded() : server.noForwarded();
        return this.applyCustomizers(server);
    }

    private HttpProtocol[] listProtocols() {
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            if (this.getSsl() != null && this.getSsl().isEnabled()) {
                return new HttpProtocol[]{HttpProtocol.H2, HttpProtocol.HTTP11};
            }
            return new HttpProtocol[]{HttpProtocol.H2C, HttpProtocol.HTTP11};
        }
        return new HttpProtocol[]{HttpProtocol.HTTP11};
    }

    private InetSocketAddress getListenAddress() {
        if (this.getAddress() != null) {
            return new InetSocketAddress(this.getAddress().getHostAddress(), this.getPort());
        }
        return new InetSocketAddress(this.getPort());
    }

    private HttpServer applyCustomizers(HttpServer server) {
        for (NettyServerCustomizer customizer : this.serverCustomizers) {
            server = (HttpServer)customizer.apply(server);
        }
        return server;
    }
}

