/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloud;

import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.StringUtils;

public enum CloudPlatform {
    CLOUD_FOUNDRY{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("VCAP_APPLICATION") || environment.containsProperty("VCAP_SERVICES");
        }
    }
    ,
    HEROKU{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("DYNO");
        }
    }
    ,
    SAP{

        @Override
        public boolean isActive(Environment environment) {
            return environment.containsProperty("HC_LANDSCAPE");
        }
    }
    ,
    KUBERNETES{

        @Override
        public boolean isActive(Environment environment) {
            MapPropertySource propertySource;
            if (environment instanceof ConfigurableEnvironment && (propertySource = (MapPropertySource)((ConfigurableEnvironment)environment).getPropertySources().get("systemEnvironment")) != null) {
                for (String name : propertySource.getPropertyNames()) {
                    String serviceName;
                    if (!name.endsWith("_SERVICE_HOST") || propertySource.getProperty((serviceName = StringUtils.split((String)name, (String)"_SERVICE_HOST")[0]) + "_SERVICE_PORT") == null) continue;
                    return true;
                }
            }
            return false;
        }
    };


    public abstract boolean isActive(Environment var1);

    public boolean isUsingForwardHeaders() {
        return true;
    }

    public static CloudPlatform getActive(Environment environment) {
        if (environment != null) {
            for (CloudPlatform cloudPlatform : CloudPlatform.values()) {
                if (!cloudPlatform.isActive(environment)) continue;
                return cloudPlatform;
            }
        }
        return null;
    }
}

