/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.netty;

import java.time.Duration;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import reactor.netty.DisposableServer;

final class GracefulShutdown {
    private static final Log logger = LogFactory.getLog(GracefulShutdown.class);
    private final Supplier<DisposableServer> disposableServer;
    private volatile Thread shutdownThread;
    private volatile boolean shuttingDown;

    GracefulShutdown(Supplier<DisposableServer> disposableServer) {
        this.disposableServer = disposableServer;
    }

    void shutDownGracefully(GracefulShutdownCallback callback) {
        DisposableServer server = this.disposableServer.get();
        if (server == null) {
            return;
        }
        logger.info((Object)"Commencing graceful shutdown. Waiting for active requests to complete");
        this.shutdownThread = new Thread(() -> this.doShutdown(callback, server), "netty-shutdown");
        this.shutdownThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShutdown(GracefulShutdownCallback callback, DisposableServer server) {
        this.shuttingDown = true;
        try {
            server.disposeNow(Duration.ofMillis(Long.MAX_VALUE));
            logger.info((Object)"Graceful shutdown complete");
            callback.shutdownComplete(GracefulShutdownResult.IDLE);
        }
        catch (Exception ex) {
            logger.info((Object)"Graceful shutdown aborted with one or more active requests");
            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        }
        finally {
            this.shutdownThread = null;
            this.shuttingDown = false;
        }
    }

    void abort() {
        Thread shutdownThread = this.shutdownThread;
        if (shutdownThread != null) {
            while (!this.shuttingDown) {
                this.sleep(50L);
            }
            this.shutdownThread.interrupt();
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

