/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.util.PathMatcher;

public class ServiceMatcher {
    private BusProperties context;
    private PathMatcher matcher;

    public void setBusProperties(BusProperties context) {
        this.context = context;
    }

    public void setMatcher(PathMatcher matcher) {
        this.matcher = matcher;
    }

    public boolean isFromSelf(RemoteApplicationEvent event) {
        String originService = event.getOriginService();
        String serviceId = this.getServiceId();
        return this.matcher.match(originService, serviceId);
    }

    public boolean isForSelf(RemoteApplicationEvent event) {
        String destinationService = event.getDestinationService();
        return destinationService == null || destinationService.trim().isEmpty() || this.matcher.match(destinationService, this.getServiceId());
    }

    public String getServiceId() {
        return this.context.getId();
    }
}

