/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.web.trace.HttpTraceRepository;
import org.springframework.cloud.bus.event.AckRemoteApplicationEvent;
import org.springframework.cloud.bus.event.SentApplicationEvent;
import org.springframework.context.event.EventListener;

public class TraceListener {
    private static Log log = LogFactory.getLog(TraceListener.class);
    private HttpTraceRepository repository;

    public TraceListener(HttpTraceRepository repository) {
        this.repository = repository;
    }

    @EventListener
    public void onAck(AckRemoteApplicationEvent event) {
        Map<String, Object> trace = this.getReceivedTrace(event);
    }

    @EventListener
    public void onSend(SentApplicationEvent event) {
        Map<String, Object> trace = this.getSentTrace(event);
    }

    protected Map<String, Object> getSentTrace(SentApplicationEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("signal", "spring.cloud.bus.sent");
        map.put("type", event.getType().getSimpleName());
        map.put("id", event.getId());
        map.put("origin", event.getOriginService());
        map.put("destination", event.getDestinationService());
        if (log.isDebugEnabled()) {
            log.debug(map);
        }
        return map;
    }

    protected Map<String, Object> getReceivedTrace(AckRemoteApplicationEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("signal", "spring.cloud.bus.ack");
        map.put("event", event.getEvent().getSimpleName());
        map.put("id", event.getAckId());
        map.put("origin", event.getOriginService());
        map.put("destination", event.getAckDestinationService());
        if (log.isDebugEnabled()) {
            log.debug(map);
        }
        return map;
    }
}

