/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.domain.ConfigValues;
import org.springframework.cloud.skipper.domain.FileHolder;
import org.springframework.cloud.skipper.domain.Package;
import org.springframework.cloud.skipper.domain.PackageMetadata;
import org.springframework.cloud.skipper.domain.Template;
import org.springframework.cloud.skipper.io.PackageReader;
import org.springframework.util.Assert;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import org.zeroturnaround.zip.commons.FileUtils;

public class DefaultPackageReader
implements PackageReader {
    @Override
    public Package read(File packageDirectory) {
        List files;
        Assert.notNull((Object)packageDirectory, (String)"File to load package from can not be null");
        try (Stream<Path> paths = Files.walk(Paths.get(packageDirectory.getPath(), new String[0]), 1, new FileVisitOption[0]);){
            files = paths.map(i -> i.toAbsolutePath().toFile()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new SkipperException("Could not process files in path " + packageDirectory.getPath() + ". " + e.getMessage(), e);
        }
        Package pkg = new Package();
        ArrayList<FileHolder> fileHolders = new ArrayList<FileHolder>();
        for (File file : files) {
            if (file.getName().equalsIgnoreCase("package.yaml") || file.getName().equalsIgnoreCase("package.yml")) {
                pkg.setMetadata(this.loadPackageMetadata(file));
                continue;
            }
            if (file.getName().endsWith("manifest.yaml") || file.getName().endsWith("manifest.yml")) {
                fileHolders.add(this.loadManifestFile(file));
                continue;
            }
            if (file.getName().equalsIgnoreCase("values.yaml") || file.getName().equalsIgnoreCase("values.yml")) {
                pkg.setConfigValues(this.loadConfigValues(file));
                continue;
            }
            File absoluteFile = file.getAbsoluteFile();
            if (absoluteFile.isDirectory() && absoluteFile.getName().equals("templates")) {
                pkg.setTemplates(this.loadTemplates(file));
                continue;
            }
            if (!file.getName().equalsIgnoreCase("packages") || !file.isDirectory()) continue;
            File[] dependentPackageDirectories = file.listFiles();
            ArrayList<Package> dependencies = new ArrayList<Package>();
            for (File dependentPackageDirectory : dependentPackageDirectories) {
                dependencies.add(this.read(dependentPackageDirectory));
            }
            pkg.setDependencies(dependencies);
        }
        if (!fileHolders.isEmpty()) {
            pkg.setFileHolders(fileHolders);
        }
        return pkg;
    }

    private List<Template> loadTemplates(File templatePath) {
        List files;
        try {
            Stream<Path> paths = Files.walk(Paths.get(templatePath.getAbsolutePath(), new String[0]), 1, new FileVisitOption[0]);
            Object object = null;
            try {
                files = paths.map(i -> i.toAbsolutePath().toFile()).collect(Collectors.toList());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (paths != null) {
                    if (object != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new SkipperException("Could not process files in template path " + templatePath, e);
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        for (File file : files) {
            if (!this.isYamlFile(file)) continue;
            Template template = new Template();
            template.setName(file.getName());
            try {
                template.setData(new String(Files.readAllBytes(file.toPath()), "UTF-8"));
            }
            catch (IOException e) {
                throw new SkipperException("Could read template file " + file.getAbsoluteFile(), e);
            }
            templates.add(template);
        }
        return templates;
    }

    private boolean isYamlFile(File file) {
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        String fileName = path.getFileName().toString();
        if (!fileName.startsWith(".")) {
            return fileName.endsWith("yml") || fileName.endsWith("yaml");
        }
        return false;
    }

    private ConfigValues loadConfigValues(File file) {
        ConfigValues configValues = new ConfigValues();
        try {
            configValues.setRaw(new String(Files.readAllBytes(file.toPath()), "UTF-8"));
        }
        catch (IOException e) {
            throw new SkipperException("Could read values file " + file.getAbsoluteFile(), e);
        }
        return configValues;
    }

    private FileHolder loadManifestFile(File file) {
        try {
            return new FileHolder(file.getName(), Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new SkipperException("Could read values file " + file.getAbsoluteFile(), e);
        }
    }

    private PackageMetadata loadPackageMetadata(File file) {
        DumperOptions options = new DumperOptions();
        Representer representer = new Representer(options);
        representer.getPropertyUtils().setSkipMissingProperties(true);
        LoaderOptions loaderOptions = new LoaderOptions();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(PackageMetadata.class, loaderOptions), representer);
        String fileContents = null;
        try {
            fileContents = FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new SkipperException("Error reading yaml file", e);
        }
        PackageMetadata pkgMetadata = (PackageMetadata)yaml.load(fileContents);
        return pkgMetadata;
    }
}

