/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.skipper.SkipperException;
import org.springframework.cloud.skipper.domain.AbstractEntity;
import org.springframework.cloud.skipper.domain.ConfigValues;
import org.springframework.cloud.skipper.domain.Info;
import org.springframework.cloud.skipper.domain.Manifest;
import org.springframework.cloud.skipper.domain.Package;
import org.springframework.util.StringUtils;

@Entity
@Table(name="SkipperRelease", indexes={@Index(name="idx_rel_name", columnList="name")})
public class Release
extends AbstractEntity {
    @NotNull
    private String name;
    private int version;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(foreignKey=@ForeignKey(name="fk_release_info"))
    private Info info;
    @Transient
    private Package pkg;
    @JsonIgnore
    private Long packageMetadataId;
    @JsonIgnore
    private Long repositoryId;
    @Lob
    private String pkgJsonString;
    @Transient
    private ConfigValues configValues = new ConfigValues();
    @Lob
    private String configValuesString;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(foreignKey=@ForeignKey(name="fk_release_manifest"))
    private Manifest manifest;
    private String platformName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Package getPkg() {
        return this.pkg;
    }

    public void setPkg(Package pkg) {
        this.pkg = pkg;
        this.packageMetadataId = pkg.getMetadata().getId();
        this.repositoryId = pkg.getMetadata().getRepositoryId();
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.pkgJsonString = mapper.writeValueAsString((Object)pkg);
        }
        catch (JsonProcessingException e) {
            throw new SkipperException("Error processing pkg json string", e);
        }
    }

    public Long getPackageMetadataId() {
        return this.packageMetadataId;
    }

    public void setPackageMetadataId(Long packageMetadataId) {
        this.packageMetadataId = packageMetadataId;
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public ConfigValues getConfigValues() {
        if (this.configValues == null) {
            return new ConfigValues();
        }
        return this.configValues;
    }

    public void setConfigValues(ConfigValues configValues) {
        this.configValues = configValues;
        if (configValues != null && StringUtils.hasText((String)configValues.getRaw())) {
            this.configValuesString = configValues.getRaw();
        }
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    @PostLoad
    public void afterLoad() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            this.pkg = (Package)mapper.readValue(this.pkgJsonString, Package.class);
            this.configValues = new ConfigValues();
            if (this.configValuesString != null && StringUtils.hasText((String)this.configValuesString)) {
                this.configValues.setRaw(this.configValuesString);
            }
        }
        catch (IOException e) {
            throw new SkipperException("Error processing config values", e);
        }
    }
}

