/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.MergableProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.CustomValidatorBean;

public class BindingService
implements ApplicationContextAware {
    private final CustomValidatorBean validator;
    private final Log log = LogFactory.getLog(BindingService.class);
    private final BindingServiceProperties bindingServiceProperties;
    private final Map<String, Binding<?>> producerBindings = new HashMap();
    private final Map<String, List<Binding<?>>> consumerBindings = new HashMap();
    private final TaskScheduler taskScheduler;
    private final BinderFactory binderFactory;
    private ConfigurableApplicationContext applicationContext;

    public BindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory) {
        this(bindingServiceProperties, binderFactory, null);
    }

    public BindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, TaskScheduler taskScheduler) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.binderFactory = binderFactory;
        this.validator = new CustomValidatorBean();
        this.validator.afterPropertiesSet();
        this.taskScheduler = taskScheduler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public <T> Collection<Binding<T>> bindConsumer(T input, String inputName) {
        ArrayList<Binding<T>> bindings = new ArrayList<Binding<T>>();
        org.springframework.cloud.stream.binder.Binder<?, ?, ?> binder = this.getBinder(inputName, input.getClass());
        ExtendedConsumerProperties consumerProperties = this.bindingServiceProperties.getConsumerProperties(inputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            Object extension = ((ExtendedPropertiesBinder)binder).getExtendedConsumerProperties(inputName);
            ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(extension);
            BeanUtils.copyProperties((Object)consumerProperties, extendedConsumerProperties);
            if (MergableProperties.class.isAssignableFrom(extendedConsumerProperties.getExtension().getClass())) {
                this.handleExtendedDefaultProperties((ExtendedPropertiesBinder)binder, (MergableProperties)extendedConsumerProperties.getExtension(), false);
            }
            consumerProperties = extendedConsumerProperties;
        }
        this.validate(consumerProperties);
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(inputName);
        if (consumerProperties.isMultiplex()) {
            bindings.add(this.doBindConsumer(input, inputName, binder, consumerProperties, bindingTarget));
        } else {
            String[] bindingTargets;
            for (String target : bindingTargets = StringUtils.commaDelimitedListToStringArray((String)bindingTarget)) {
                Binding<T> binding = input instanceof PollableSource ? this.doBindPollableConsumer(input, inputName, binder, consumerProperties, target) : this.doBindConsumer(input, inputName, binder, consumerProperties, target);
                bindings.add(binding);
            }
        }
        bindings = Collections.unmodifiableCollection(bindings);
        this.consumerBindings.put(inputName, new ArrayList(bindings));
        return bindings;
    }

    public <T> Binding<T> doBindConsumer(T input, String inputName, org.springframework.cloud.stream.binder.Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties);
        }
        try {
            return binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding();
            this.rescheduleConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            return late;
        }
    }

    public <T> void rescheduleConsumerBinding(T input, String inputName, org.springframework.cloud.stream.binder.Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create consumer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties));
            }
            catch (RuntimeException e) {
                this.rescheduleConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            }
        });
    }

    public <T> Binding<T> doBindPollableConsumer(T input, String inputName, org.springframework.cloud.stream.binder.Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return ((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties);
        }
        try {
            return ((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding();
            this.reschedulePollableConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            return late;
        }
    }

    public <T> void reschedulePollableConsumerBinding(T input, String inputName, org.springframework.cloud.stream.binder.Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create consumer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties));
            }
            catch (RuntimeException e) {
                this.reschedulePollableConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            }
        });
    }

    public <T> Binding<T> bindProducer(T output, String outputName) {
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(outputName);
        org.springframework.cloud.stream.binder.Binder<?, ?, ?> binder = this.getBinder(outputName, output.getClass());
        ExtendedProducerProperties producerProperties = this.bindingServiceProperties.getProducerProperties(outputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            Object extension = ((ExtendedPropertiesBinder)binder).getExtendedProducerProperties(outputName);
            ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties(extension);
            BeanUtils.copyProperties((Object)producerProperties, extendedProducerProperties);
            if (MergableProperties.class.isAssignableFrom(extendedProducerProperties.getExtension().getClass())) {
                this.handleExtendedDefaultProperties((ExtendedPropertiesBinder)binder, (MergableProperties)extendedProducerProperties.getExtension(), true);
            }
            producerProperties = extendedProducerProperties;
        }
        this.validate(producerProperties);
        Binding<T> binding = this.doBindProducer(output, bindingTarget, binder, producerProperties);
        this.producerBindings.put(outputName, binding);
        return binding;
    }

    private void handleExtendedDefaultProperties(ExtendedPropertiesBinder<?, ?, ?> binder, MergableProperties extendedProperties, boolean producer) {
        Class<BinderSpecificPropertiesProvider> extendedPropertiesEntryClass;
        String defaultsPrefix = binder.getDefaultsPrefix();
        if (defaultsPrefix != null && BinderSpecificPropertiesProvider.class.isAssignableFrom(extendedPropertiesEntryClass = binder.getExtendedPropertiesEntryClass())) {
            Binder extendedPropertiesResolverBinder = new Binder(ConfigurationPropertySources.get((Environment)this.applicationContext.getEnvironment()), (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Environment)this.applicationContext.getEnvironment()), IntegrationUtils.getConversionService((BeanFactory)this.applicationContext.getBeanFactory()), null);
            BinderSpecificPropertiesProvider defaultProperties = (BinderSpecificPropertiesProvider)BeanUtils.instantiateClass(extendedPropertiesEntryClass);
            extendedPropertiesResolverBinder.bind(defaultsPrefix, Bindable.ofInstance((Object)defaultProperties));
            Object binderExtendedProperties = producer ? defaultProperties.getProducer() : defaultProperties.getConsumer();
            ((MergableProperties)binderExtendedProperties).merge(extendedProperties);
        }
    }

    public Object getExtendedProducerProperties(Object output, String outputName) {
        org.springframework.cloud.stream.binder.Binder<?, ?, ?> binder = this.getBinder(outputName, output.getClass());
        if (binder instanceof ExtendedPropertiesBinder) {
            return ((ExtendedPropertiesBinder)binder).getExtendedProducerProperties(outputName);
        }
        return null;
    }

    public <T> Binding<T> doBindProducer(T output, String bindingTarget, org.springframework.cloud.stream.binder.Binder<T, ?, ProducerProperties> binder, ProducerProperties producerProperties) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return binder.bindProducer(bindingTarget, output, producerProperties);
        }
        try {
            return binder.bindProducer(bindingTarget, output, producerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding();
            this.rescheduleProducerBinding(output, bindingTarget, binder, producerProperties, late, e);
            return late;
        }
    }

    public <T> void rescheduleProducerBinding(T output, String bindingTarget, org.springframework.cloud.stream.binder.Binder<T, ?, ProducerProperties> binder, ProducerProperties producerProperties, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create producer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(binder.bindProducer(bindingTarget, output, producerProperties));
            }
            catch (RuntimeException e) {
                this.rescheduleProducerBinding(output, bindingTarget, binder, producerProperties, late, e);
            }
        });
    }

    public void unbindConsumers(String inputName) {
        List<Binding<?>> bindings = this.consumerBindings.remove(inputName);
        if (bindings != null && !CollectionUtils.isEmpty(bindings)) {
            for (Binding<?> binding : bindings) {
                binding.unbind();
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + inputName + "', but no binding found."));
        }
    }

    public void unbindProducers(String outputName) {
        Binding<?> binding = this.producerBindings.remove(outputName);
        if (binding != null) {
            binding.unbind();
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + outputName + "', but no binding found."));
        }
    }

    @Deprecated
    public BindingServiceProperties getChannelBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    public BindingServiceProperties getBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    protected <T> org.springframework.cloud.stream.binder.Binder<T, ?, ?> getBinder(String channelName, Class<T> bindableType) {
        String binderConfigurationName = this.bindingServiceProperties.getBinder(channelName);
        return this.binderFactory.getBinder(binderConfigurationName, bindableType);
    }

    private void validate(Object properties) {
        DataBinder dataBinder = new DataBinder(properties);
        dataBinder.setValidator((Validator)this.validator);
        dataBinder.validate();
        if (dataBinder.getBindingResult().hasErrors()) {
            throw new IllegalStateException(dataBinder.getBindingResult().toString());
        }
    }

    private void scheduleTask(Runnable task) {
        this.taskScheduler.schedule(task, (java.util.Date)new Date(System.currentTimeMillis() + (long)(this.bindingServiceProperties.getBindingRetryInterval() * 1000)));
    }

    private void assertNotIllegalException(RuntimeException exception) throws RuntimeException {
        if (exception instanceof IllegalStateException || exception instanceof IllegalArgumentException) {
            throw exception;
        }
    }

    private static class LateBinding<T>
    implements Binding<T> {
        private volatile Binding<T> delegate;
        private volatile boolean unbound;

        LateBinding() {
        }

        public synchronized void setDelegate(Binding<T> delegate) {
            if (this.unbound) {
                delegate.unbind();
            } else {
                this.delegate = delegate;
            }
        }

        @Override
        public synchronized void unbind() {
            this.unbound = true;
            if (this.delegate != null) {
                this.delegate.unbind();
            }
        }

        public String toString() {
            return "LateBinding [delegate=" + this.delegate + "]";
        }
    }
}

