/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public interface MergableProperties {
    default public void merge(MergableProperties mergable) {
        if (mergable == null) {
            return;
        }
        for (PropertyDescriptor targetPd : BeanUtils.getPropertyDescriptors(mergable.getClass())) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = BeanUtils.getPropertyDescriptor(this.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object obj;
                Object defaultValue;
                Object value;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke((Object)this, new Object[0])) == null) continue;
                if (value instanceof MergableProperties) {
                    ((MergableProperties)value).merge((MergableProperties)readMethod.invoke((Object)mergable, new Object[0]));
                    continue;
                }
                Object v = readMethod.invoke((Object)mergable, new Object[0]);
                if (v == null || ObjectUtils.isArray((Object)v) && ObjectUtils.isEmpty((Object)v) || this.isEmptyMapAtDestination(v)) {
                    if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                        writeMethod.setAccessible(true);
                    }
                    writeMethod.invoke((Object)mergable, value);
                    continue;
                }
                if (this.isMergableByMap(v)) {
                    this.handleMapMerging(value, v);
                    continue;
                }
                if (ObjectUtils.nullSafeEquals((Object)v, (Object)value) || !ObjectUtils.nullSafeEquals((Object)v, (Object)(defaultValue = readMethod.invoke(obj = BeanUtils.instantiateClass(this.getClass()), new Object[0])))) continue;
                writeMethod.invoke((Object)mergable, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    default public boolean isEmptyMapAtDestination(Object v) {
        return Map.class.isAssignableFrom(v.getClass()) && CollectionUtils.isEmpty((Map)((Map)v));
    }

    default public boolean isMergableByMap(Object v) {
        return Map.class.isAssignableFrom(v.getClass()) && !CollectionUtils.isEmpty((Map)((Map)v));
    }

    default public void handleMapMerging(Object value, Object v) {
        if (value instanceof Map) {
            Map sourceMap = (Map)value;
            Iterator iterator = sourceMap.keySet().iterator();
            while (iterator.hasNext()) {
                Map targetMap = (Map)v;
                Object key = iterator.next();
                if (targetMap.containsKey(key)) continue;
                targetMap.put(key, sourceMap.get(key));
            }
        }
    }

    default public void copyProperties(Object source, Object target) throws BeansException {
    }
}

