/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.util.Assert;

@Endpoint(id="bindings")
public class BindingsEndpoint {
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final List<OutputBindingLifecycle> outputBindingsLifecycles;
    private final ObjectMapper objectMapper;

    public BindingsEndpoint(List<InputBindingLifecycle> inputBindingLifecycles, List<OutputBindingLifecycle> outputBindingsLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.outputBindingsLifecycles = outputBindingsLifecycles;
        this.objectMapper = new ObjectMapper();
    }

    @WriteOperation
    public void changeState(@Selector String name, State state) {
        Binding<?> binding = this.locateBinding(name);
        if (binding != null) {
            switch (state) {
                case STARTED: {
                    binding.start();
                    break;
                }
                case STOPPED: {
                    binding.stop();
                    break;
                }
                case PAUSED: {
                    binding.pause();
                    break;
                }
                case RESUMED: {
                    binding.resume();
                    break;
                }
            }
        }
    }

    @ReadOperation
    public List<?> queryStates() {
        ArrayList bindings = new ArrayList(this.gatherInputBindings());
        bindings.addAll(this.gatherOutputBindings());
        return (List)this.objectMapper.convertValue(bindings, List.class);
    }

    @ReadOperation
    public Binding<?> queryState(@Selector String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return this.locateBinding(name);
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private List<Binding<?>> gatherOutputBindings() {
        ArrayList outputBindings = new ArrayList();
        for (OutputBindingLifecycle inputBindingLifecycle : this.outputBindingsLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("outputBindings");
            outputBindings.addAll(lifecycleInputBindings);
        }
        return outputBindings;
    }

    private Binding<?> locateBinding(String name) {
        Stream bindings = Stream.concat(this.gatherInputBindings().stream(), this.gatherOutputBindings().stream());
        return bindings.filter(binding -> name.equals(binding.getName())).findFirst().orElse(null);
    }

    private static enum State {
        STARTED,
        STOPPED,
        PAUSED,
        RESUMED;

    }
}

