/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.function.FunctionCatalogWrapper;
import org.springframework.cloud.stream.function.IntegrationFlowFunctionSupport;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.cloud.stream.messaging.Processor;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.stream.function.definition"})
@EnableConfigurationProperties(value={StreamFunctionProperties.class})
public class FunctionConfiguration {
    @Autowired(required=false)
    private Source source;
    @Autowired(required=false)
    private Processor processor;
    @Autowired(required=false)
    private Sink sink;

    @Bean
    public IntegrationFlowFunctionSupport functionSupport(FunctionCatalogWrapper functionCatalog, FunctionInspector functionInspector, CompositeMessageConverterFactory messageConverterFactory, StreamFunctionProperties functionProperties) {
        return new IntegrationFlowFunctionSupport(functionCatalog, functionInspector, messageConverterFactory, functionProperties);
    }

    @Bean
    public FunctionCatalogWrapper functionCatalogWrapper(FunctionCatalog catalog) {
        return new FunctionCatalogWrapper(catalog);
    }

    @ConditionalOnMissingBean
    @Bean
    public IntegrationFlow integrationFlowCreator(IntegrationFlowFunctionSupport functionSupport) {
        if (this.processor != null) {
            return functionSupport.containsFunction(Function.class) ? functionSupport.integrationFlowForFunction(this.processor.input(), this.processor.output()).get() : null;
        }
        if (this.source != null && this.processor == null) {
            return functionSupport.containsFunction(Supplier.class) ? ((IntegrationFlowBuilder)functionSupport.integrationFlowFromNamedSupplier().channel(this.source.output())).get() : null;
        }
        return null;
    }
}

