/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.context.FunctionType;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.function.FunctionCatalogWrapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

class FunctionInvoker<I, O>
implements Function<Flux<Message<I>>, Flux<Message<O>>> {
    private static final Log logger = LogFactory.getLog(FunctionInvoker.class);
    private final Class<?> inputClass;
    private final Class<?> outputClass;
    private final Function<Flux<?>, Flux<?>> userFunction;
    private final CompositeMessageConverter messageConverter;
    private final MessageChannel errorChannel;
    private final boolean isInputArgumentMessage;

    FunctionInvoker(String functionName, FunctionCatalogWrapper functionCatalog, FunctionInspector functionInspector, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        this(functionName, functionCatalog, functionInspector, compositeMessageConverterFactory, null);
    }

    FunctionInvoker(String functionName, FunctionCatalogWrapper functionCatalog, FunctionInspector functionInspector, CompositeMessageConverterFactory compositeMessageConverterFactory, MessageChannel errorChannel) {
        this.userFunction = (Function)functionCatalog.lookup(functionName);
        Assert.isInstanceOf(Function.class, this.userFunction);
        this.messageConverter = compositeMessageConverterFactory.getMessageConverterForAllRegistered();
        FunctionType functionType = functionInspector.getRegistration(this.userFunction).getType();
        this.isInputArgumentMessage = functionType.isMessage();
        this.inputClass = functionType.getInputType();
        this.outputClass = functionType.getOutputType();
        this.errorChannel = errorChannel;
    }

    @Override
    public Flux<Message<O>> apply(Flux<Message<I>> input) {
        AtomicReference originalMessageRef = new AtomicReference();
        return input.doOnNext(originalMessageRef::set).map(this::resolveArgument).onErrorContinue((x, y) -> this.onError((Throwable)x, (Message<I>)((Message)y))).transform(this.userFunction::apply).onErrorContinue((x, y) -> this.onError((Throwable)x, (Message<I>)((Message)y))).map(resultMessage -> this.toMessage(resultMessage, (Message)originalMessageRef.get()));
    }

    private void onError(Throwable t, Message<I> originalMessage) {
        if (this.errorChannel != null) {
            ErrorMessage em = new ErrorMessage(t, originalMessage);
            logger.error((Object)em);
            this.errorChannel.send((Message)em);
        } else {
            logger.error((Object)t);
        }
    }

    private <T> Message<O> toMessage(T value, Message<I> originalMessage) {
        Message returnMessage;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converting result back to message using the original message: " + originalMessage));
        }
        if ((returnMessage = (Message)(value instanceof Message ? value : this.messageConverter.toMessage(value, originalMessage.getHeaders(), this.outputClass))) == null && value.getClass().isAssignableFrom(this.outputClass)) {
            returnMessage = MessageBuilder.withPayload(value).copyHeaders((Map)originalMessage.getHeaders()).removeHeader("contentType").build();
        }
        Assert.notNull((Object)returnMessage, (String)("Failed to convert result value '" + value + "' to message."));
        return returnMessage;
    }

    private <T> T resolveArgument(Message<I> message) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving input argument from message: " + message));
        }
        Object argument = this.shouldConvertFromMessage(message) ? this.messageConverter.fromMessage(message, this.inputClass) : message;
        Assert.notNull(argument, (String)("Failed to resolve argument type '" + this.inputClass + "' from message: " + message));
        if (!this.isInputArgumentMessage && argument instanceof Message) {
            argument = argument.getPayload();
        }
        return (T)argument;
    }

    private boolean shouldConvertFromMessage(Message<?> message) {
        return !this.inputClass.isAssignableFrom(Message.class) && !message.getPayload().getClass().isAssignableFrom(this.inputClass) && !this.inputClass.isAssignableFrom(Object.class);
    }
}

