/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.stream.aggregate.SharedBindingTargetRegistry;
import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.binding.BindingBeanDefinitionRegistryUtils;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.BindingTargetFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BindableProxyFactory
implements MethodInterceptor,
FactoryBean<Object>,
Bindable,
InitializingBean {
    private static Log log = LogFactory.getLog(BindableProxyFactory.class);
    private final Map<Method, Object> targetCache = new HashMap<Method, Object>(2);
    @Value(value="${spring.cloud.stream.internal.namespace:}")
    private String namespace;
    @Autowired(required=false)
    private SharedBindingTargetRegistry sharedBindingTargetRegistry;
    @Autowired
    private Map<String, BindingTargetFactory> bindingTargetFactories;
    private Class<?> type;
    private Object proxy;
    private Map<String, BoundTargetHolder> inputHolders = new HashMap<String, BoundTargetHolder>();
    private Map<String, BoundTargetHolder> outputHolders = new HashMap<String, BoundTargetHolder>();

    public BindableProxyFactory(Class<?> type) {
        this.type = type;
    }

    public synchronized Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object boundTarget = this.targetCache.get(method);
        if (boundTarget != null) {
            return boundTarget;
        }
        Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
        if (input != null) {
            String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(input, method);
            boundTarget = this.inputHolders.get(name).getBoundTarget();
            this.targetCache.put(method, boundTarget);
            return boundTarget;
        }
        Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
        if (output != null) {
            String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(output, method);
            boundTarget = this.outputHolders.get(name).getBoundTarget();
            this.targetCache.put(method, boundTarget);
            return boundTarget;
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        ReflectionUtils.doWithMethods(this.type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Input input = (Input)AnnotationUtils.findAnnotation((Method)method, Input.class);
                if (input != null) {
                    Class<?> returnType;
                    String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(input, method);
                    Object sharedBindingTarget = BindableProxyFactory.this.locateSharedBindingTarget(name, returnType = method.getReturnType());
                    if (sharedBindingTarget != null) {
                        BindableProxyFactory.this.inputHolders.put(name, new BoundTargetHolder(sharedBindingTarget, false));
                    } else {
                        BindableProxyFactory.this.inputHolders.put(name, new BoundTargetHolder(BindableProxyFactory.this.getBindingTargetFactory(returnType).createInput(name), true));
                    }
                }
            }
        });
        ReflectionUtils.doWithMethods(this.type, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Output output = (Output)AnnotationUtils.findAnnotation((Method)method, Output.class);
                if (output != null) {
                    Class<?> returnType;
                    String name = BindingBeanDefinitionRegistryUtils.getBindingTargetName(output, method);
                    Object sharedBindingTarget = BindableProxyFactory.this.locateSharedBindingTarget(name, returnType = method.getReturnType());
                    if (sharedBindingTarget != null) {
                        BindableProxyFactory.this.outputHolders.put(name, new BoundTargetHolder(sharedBindingTarget, false));
                    } else {
                        BindableProxyFactory.this.outputHolders.put(name, new BoundTargetHolder(BindableProxyFactory.this.getBindingTargetFactory(returnType).createOutput(name), true));
                    }
                }
            }
        });
    }

    private BindingTargetFactory getBindingTargetFactory(Class<?> bindingTargetType) {
        ArrayList<String> candidateBindingTargetFactories = new ArrayList<String>();
        for (Map.Entry<String, BindingTargetFactory> bindingTargetFactoryEntry : this.bindingTargetFactories.entrySet()) {
            if (!bindingTargetFactoryEntry.getValue().canCreate(bindingTargetType)) continue;
            candidateBindingTargetFactories.add(bindingTargetFactoryEntry.getKey());
        }
        if (candidateBindingTargetFactories.size() == 1) {
            return this.bindingTargetFactories.get(candidateBindingTargetFactories.get(0));
        }
        if (candidateBindingTargetFactories.size() == 0) {
            throw new IllegalStateException("No factory found for binding target type: " + bindingTargetType.getName() + " among registered factories: " + StringUtils.collectionToCommaDelimitedString(this.bindingTargetFactories.keySet()));
        }
        throw new IllegalStateException("Multiple factories found for binding target type: " + bindingTargetType.getName() + ": " + StringUtils.collectionToCommaDelimitedString(candidateBindingTargetFactories));
    }

    private <T> T locateSharedBindingTarget(String name, Class<T> bindingTargetType) {
        return this.sharedBindingTargetRegistry != null ? (T)this.sharedBindingTargetRegistry.get(this.getNamespacePrefixedBindingTargetName(name), bindingTargetType) : null;
    }

    private String getNamespacePrefixedBindingTargetName(String name) {
        return this.namespace + "." + name;
    }

    public synchronized Object getObject() throws Exception {
        if (this.proxy == null) {
            ProxyFactory factory = new ProxyFactory(this.type, (Interceptor)this);
            this.proxy = factory.getProxy();
        }
        return this.proxy;
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public Collection<Binding<Object>> createAndBindInputs(BindingService bindingService) {
        ArrayList<Binding<Object>> bindings = new ArrayList<Binding<Object>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding inputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.inputHolders.entrySet()) {
            String inputTargetName = boundTargetHolderEntry.getKey();
            BoundTargetHolder boundTargetHolder = boundTargetHolderEntry.getValue();
            if (!boundTargetHolder.isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, inputTargetName));
            }
            bindings.addAll(bindingService.bindConsumer(boundTargetHolder.getBoundTarget(), inputTargetName));
        }
        return bindings;
    }

    @Override
    public Collection<Binding<Object>> createAndBindOutputs(BindingService bindingService) {
        ArrayList<Binding<Object>> bindings = new ArrayList<Binding<Object>>();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Binding outputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.outputHolders.entrySet()) {
            BoundTargetHolder boundTargetHolder = boundTargetHolderEntry.getValue();
            String outputTargetName = boundTargetHolderEntry.getKey();
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, outputTargetName));
            }
            bindings.add(bindingService.bindProducer(boundTargetHolder.getBoundTarget(), outputTargetName));
        }
        return bindings;
    }

    @Override
    public void unbindInputs(BindingService bindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding inputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.inputHolders.entrySet()) {
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Unbinding %s:%s:%s", this.namespace, this.type, boundTargetHolderEntry.getKey()));
            }
            bindingService.unbindConsumers(boundTargetHolderEntry.getKey());
        }
    }

    @Override
    public void unbindOutputs(BindingService bindingService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unbinding outputs for %s:%s", this.namespace, this.type));
        }
        for (Map.Entry<String, BoundTargetHolder> boundTargetHolderEntry : this.outputHolders.entrySet()) {
            if (!boundTargetHolderEntry.getValue().isBindable()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Binding %s:%s:%s", this.namespace, this.type, boundTargetHolderEntry.getKey()));
            }
            bindingService.unbindProducers(boundTargetHolderEntry.getKey());
        }
    }

    @Override
    public Set<String> getInputs() {
        return this.inputHolders.keySet();
    }

    @Override
    public Set<String> getOutputs() {
        return this.outputHolders.keySet();
    }

    private final class BoundTargetHolder {
        private Object boundTarget;
        private boolean bindable;

        private BoundTargetHolder(Object boundTarget, boolean bindable) {
            this.boundTarget = boundTarget;
            this.bindable = bindable;
        }

        public Object getBoundTarget() {
            return this.boundTarget;
        }

        public boolean isBindable() {
            return this.bindable;
        }
    }
}

