/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import org.springframework.cloud.stream.binding.AbstractBindingTargetFactory;
import org.springframework.cloud.stream.binding.MessageChannelConfigurer;
import org.springframework.cloud.stream.messaging.DirectWithAttributesChannel;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

public class SubscribableChannelBindingTargetFactory
extends AbstractBindingTargetFactory<SubscribableChannel> {
    private final MessageChannelConfigurer messageChannelConfigurer;

    public SubscribableChannelBindingTargetFactory(MessageChannelConfigurer messageChannelConfigurer) {
        super(SubscribableChannel.class);
        this.messageChannelConfigurer = messageChannelConfigurer;
    }

    @Override
    public SubscribableChannel createInput(String name) {
        DirectWithAttributesChannel subscribableChannel = new DirectWithAttributesChannel();
        subscribableChannel.setAttribute("type", "input");
        this.messageChannelConfigurer.configureInputChannel((MessageChannel)subscribableChannel, name);
        return subscribableChannel;
    }

    @Override
    public SubscribableChannel createOutput(String name) {
        DirectWithAttributesChannel subscribableChannel = new DirectWithAttributesChannel();
        subscribableChannel.setAttribute("type", "output");
        this.messageChannelConfigurer.configureOutputChannel((MessageChannel)subscribableChannel, name);
        return subscribableChannel;
    }
}

