/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderErrorChannel;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.BindingCreatedEvent;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.EmbeddedHeaderUtils;
import org.springframework.cloud.stream.binder.FinalRethrowingErrorMessageHandler;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.binder.LastSubscriberAwareChannel;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.handler.advice.ErrorMessageSendingRecoverer;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractMessageChannelBinder<C extends ConsumerProperties, P extends ProducerProperties, PP extends ProvisioningProvider<C, P>>
extends AbstractBinder<MessageChannel, C, P>
implements PollableConsumerBinder<MessageHandler, C>,
ApplicationEventPublisherAware {
    protected final PP provisioningProvider;
    private final EmbeddedHeadersChannelInterceptor embeddedHeadersChannelInterceptor;
    private volatile ObjectMapper objectMapper;
    private final String[] headersToEmbed;
    private final ListenerContainerCustomizer<?> containerCustomizer;
    private final MessageSourceCustomizer<?> sourceCustomizer;
    private ProducerMessageHandlerCustomizer<MessageHandler> handlerCustomizer;
    private ConsumerEndpointCustomizer<MessageProducer> consumerCustomizer;
    private ApplicationEventPublisher applicationEventPublisher;

    public AbstractMessageChannelBinder(String[] headersToEmbed, PP provisioningProvider) {
        this(headersToEmbed, provisioningProvider, null, null);
    }

    @Override
    protected void onInit() throws Exception {
        this.objectMapper = !CollectionUtils.isEmpty((Map)this.getApplicationContext().getBeansOfType(ObjectMapper.class)) ? (ObjectMapper)this.getApplicationContext().getBean(ObjectMapper.class) : new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Expression.class, (JsonSerializer)new ExpressionSerializer(Expression.class));
        this.objectMapper.registerModule((Module)module);
    }

    public AbstractMessageChannelBinder(String[] headersToEmbed, PP provisioningProvider, @Nullable ListenerContainerCustomizer<?> containerCustomizer, @Nullable MessageSourceCustomizer<?> sourceCustomizer) {
        this.embeddedHeadersChannelInterceptor = new EmbeddedHeadersChannelInterceptor(this.logger);
        this.handlerCustomizer = (handler, destination) -> {};
        this.consumerCustomizer = (adapter, destination, group) -> {};
        this.headersToEmbed = headersToEmbed == null ? new String[]{} : headersToEmbed;
        this.provisioningProvider = provisioningProvider;
        this.containerCustomizer = containerCustomizer == null ? (c, q, g) -> {} : containerCustomizer;
        this.sourceCustomizer = sourceCustomizer == null ? (s, q, g) -> {} : sourceCustomizer;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setProducerMessageHandlerCustomizer(@Nullable ProducerMessageHandlerCustomizer<? extends MessageHandler> handlerCustomizer) {
        this.handlerCustomizer = handlerCustomizer == null ? (handler, destination) -> {} : handlerCustomizer;
    }

    public void setConsumerEndpointCustomizer(@Nullable ConsumerEndpointCustomizer<? extends MessageProducer> endpointCustomizer) {
        this.consumerCustomizer = endpointCustomizer == null ? (handler, destination, group) -> {} : endpointCustomizer;
    }

    protected <L> ListenerContainerCustomizer<L> getContainerCustomizer() {
        return this.containerCustomizer;
    }

    protected <S> MessageSourceCustomizer<S> getMessageSourceCustomizer() {
        return this.sourceCustomizer;
    }

    @Override
    public final Binding<MessageChannel> doBindProducer(final String destination, MessageChannel outputChannel, final P producerProperties) throws BinderException {
        MessageHandler producerMessageHandler;
        ProducerDestination producerDestination;
        Assert.isInstanceOf(SubscribableChannel.class, (Object)outputChannel, (String)"Binding is supported only for SubscribableChannel instances");
        try {
            producerDestination = this.provisioningProvider.provisionProducerDestination(destination, producerProperties);
            SubscribableChannel errorChannel = ((ProducerProperties)producerProperties).isErrorChannelEnabled() ? this.registerErrorInfrastructure(producerDestination) : null;
            producerMessageHandler = this.createProducerMessageHandler(producerDestination, producerProperties, outputChannel, (MessageChannel)errorChannel);
            this.customizeProducerMessageHandler(producerMessageHandler, producerDestination.getName());
            if (producerMessageHandler instanceof InitializingBean) {
                ((InitializingBean)producerMessageHandler).afterPropertiesSet();
            }
        }
        catch (Exception e) {
            if (e instanceof BinderException) {
                throw (BinderException)e;
            }
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new BinderException("Exception thrown while building outbound endpoint", e);
        }
        if (((ProducerProperties)producerProperties).isAutoStartup() && producerMessageHandler instanceof Lifecycle) {
            ((Lifecycle)producerMessageHandler).start();
        }
        this.postProcessOutputChannel(outputChannel, producerProperties);
        ((SubscribableChannel)outputChannel).subscribe((MessageHandler)new SendingHandler(producerMessageHandler, HeaderMode.embeddedHeaders.equals((Object)((ProducerProperties)producerProperties).getHeaderMode()), this.headersToEmbed, this.useNativeEncoding(producerProperties)));
        DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(destination, outputChannel, producerMessageHandler instanceof Lifecycle ? (Lifecycle)producerMessageHandler : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, producerProperties);
            }

            @Override
            public boolean isInput() {
                return false;
            }

            @Override
            public void afterUnbind() {
                try {
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(producerDestination);
                    if (producerMessageHandler instanceof DisposableBean) {
                        ((DisposableBean)producerMessageHandler).destroy();
                    }
                }
                catch (Exception e) {
                    AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                }
                AbstractMessageChannelBinder.this.afterUnbindProducer(producerDestination, producerProperties);
            }
        };
        Lifecycle companion = null;
        String companionLifecycleName = destination + "_spca";
        if (this.getApplicationContext().containsBean(companionLifecycleName)) {
            companion = (Lifecycle)this.getApplicationContext().getBean(companionLifecycleName, Lifecycle.class);
        }
        ((DefaultBinding)binding).setCompanion(companion);
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    private void customizeProducerMessageHandler(MessageHandler producerMessageHandler, String destinationName) {
        this.handlerCustomizer.configure(producerMessageHandler, destinationName);
    }

    protected boolean useNativeEncoding(P producerProperties) {
        return ((ProducerProperties)producerProperties).isUseNativeEncoding();
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, P producerProperties) {
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, P producerProperties, MessageChannel channel, MessageChannel errorChannel) throws Exception {
        return this.createProducerMessageHandler(destination, producerProperties, errorChannel);
    }

    protected abstract MessageHandler createProducerMessageHandler(ProducerDestination var1, P var2, MessageChannel var3) throws Exception;

    protected void afterUnbindProducer(ProducerDestination destination, P producerProperties) {
    }

    @Override
    public final Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputChannel, final C properties) throws BinderException {
        MessageProducer consumerEndpoint = null;
        try {
            final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
            if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
                this.enhanceMessageChannel(inputChannel);
            }
            consumerEndpoint = this.createConsumerEndpoint(destination, group, properties);
            consumerEndpoint.setOutputChannel(inputChannel);
            this.consumerCustomizer.configure(consumerEndpoint, name, group);
            if (consumerEndpoint instanceof InitializingBean) {
                ((InitializingBean)consumerEndpoint).afterPropertiesSet();
            }
            if (((ConsumerProperties)properties).isAutoStartup() && consumerEndpoint instanceof Lifecycle) {
                ((Lifecycle)consumerEndpoint).start();
            }
            DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(name, group, inputChannel, consumerEndpoint instanceof Lifecycle ? (Lifecycle)consumerEndpoint : null){

                @Override
                public Map<String, Object> getExtendedInfo() {
                    return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
                }

                @Override
                public boolean isInput() {
                    return true;
                }

                @Override
                protected void afterUnbind() {
                    try {
                        if (this.getEndpoint() instanceof DisposableBean) {
                            ((DisposableBean)this.getEndpoint()).destroy();
                        }
                    }
                    catch (Exception e) {
                        AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                    }
                    AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
                }
            };
            this.doPublishEvent(new BindingCreatedEvent(binding));
            return binding;
        }
        catch (Exception e) {
            if (consumerEndpoint instanceof Lifecycle) {
                ((Lifecycle)consumerEndpoint).stop();
            }
            if (e instanceof BinderException) {
                throw (BinderException)e;
            }
            if (e instanceof ProvisioningException) {
                throw (ProvisioningException)((Object)e);
            }
            throw new BinderException("Exception thrown while starting consumer: ", e);
        }
    }

    @Override
    public Binding<PollableSource<MessageHandler>> bindPollableConsumer(String name, String group, PollableSource<MessageHandler> inboundBindTarget, final C properties) {
        PolledConsumerResources resources;
        MessageSource<?> messageSource;
        Assert.isInstanceOf(DefaultPollableMessageSource.class, inboundBindTarget);
        DefaultPollableMessageSource bindingTarget = (DefaultPollableMessageSource)inboundBindTarget;
        final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
        if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
            bindingTarget.addInterceptor(0, this.embeddedHeadersChannelInterceptor);
        }
        if ((messageSource = (resources = this.createPolledConsumerResources(name, group, destination, properties)).getSource()) instanceof BeanFactoryAware) {
            ((BeanFactoryAware)messageSource).setBeanFactory((BeanFactory)this.getApplicationContext().getBeanFactory());
        }
        bindingTarget.setSource(messageSource);
        if (resources.getErrorInfrastructure() != null) {
            ErrorMessageStrategy ems;
            if (resources.getErrorInfrastructure().getErrorChannel() != null) {
                bindingTarget.setErrorChannel((MessageChannel)resources.getErrorInfrastructure().getErrorChannel());
            }
            if ((ems = this.getErrorMessageStrategy()) != null) {
                bindingTarget.setErrorMessageStrategy(ems);
            }
        }
        if (((ConsumerProperties)properties).getMaxAttempts() > 1) {
            bindingTarget.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            bindingTarget.setRecoveryCallback(this.getPolledConsumerRecoveryCallback(resources.getErrorInfrastructure(), properties));
        }
        this.postProcessPollableSource(bindingTarget);
        if (((ConsumerProperties)properties).isAutoStartup() && resources.getSource() instanceof Lifecycle) {
            ((Lifecycle)resources.getSource()).start();
        }
        DefaultBinding<PollableSource<MessageHandler>> binding = new DefaultBinding<PollableSource<MessageHandler>>(name, group, inboundBindTarget, resources.getSource() instanceof Lifecycle ? (Lifecycle)resources.getSource() : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
            }

            @Override
            public boolean isInput() {
                return true;
            }

            @Override
            public void afterUnbind() {
                AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
            }
        };
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
    }

    protected RecoveryCallback<Object> getPolledConsumerRecoveryCallback(ErrorInfrastructure errorInfrastructure, C properties) {
        return errorInfrastructure.getRecoverer();
    }

    protected PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, C consumerProperties) {
        throw new UnsupportedOperationException("This binder does not support pollable consumers");
    }

    private void enhanceMessageChannel(MessageChannel inputChannel) {
        ((AbstractMessageChannel)inputChannel).addInterceptor(0, (ChannelInterceptor)this.embeddedHeadersChannelInterceptor);
    }

    protected abstract MessageProducer createConsumerEndpoint(ConsumerDestination var1, String var2, C var3) throws Exception;

    protected void afterUnbindConsumer(ConsumerDestination destination, String group, C consumerProperties) {
    }

    private SubscribableChannel registerErrorInfrastructure(ProducerDestination destination) {
        String errorChannelName = this.errorsBaseName(destination);
        PublishSubscribeChannel errorChannel = new PublishSubscribeChannel();
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            Object errorChannelObject = this.getApplicationContext().getBean(errorChannelName);
            if (!(errorChannelObject instanceof SubscribableChannel)) {
                throw new IllegalStateException("Error channel '" + errorChannelName + "' must be a SubscribableChannel");
            }
            if (errorChannelObject instanceof DirectChannel) {
                errorChannelName = "bridged." + errorChannelName;
                BridgeHandler bridge = new BridgeHandler();
                bridge.setOutputChannel((MessageChannel)errorChannelObject);
                errorChannel.subscribe((MessageHandler)bridge);
            }
        } else {
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorChannelName, SubscribableChannel.class, () -> AbstractMessageChannelBinder.lambda$registerErrorInfrastructure$6((SubscribableChannel)errorChannel), new BeanDefinitionCustomizer[0]);
        }
        MessageChannel defaultErrorChannel = null;
        if (this.getApplicationContext().containsBean("errorChannel")) {
            defaultErrorChannel = (MessageChannel)this.getApplicationContext().getBean("errorChannel", MessageChannel.class);
        }
        if (defaultErrorChannel != null) {
            BridgeHandler errorBridge = new BridgeHandler();
            errorBridge.setOutputChannel(defaultErrorChannel);
            errorChannel.subscribe((MessageHandler)errorBridge);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination);
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorBridgeHandlerName, BridgeHandler.class, () -> errorBridge, new BeanDefinitionCustomizer[0]);
        }
        return errorChannel;
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties) {
        return this.registerErrorInfrastructure(destination, group, consumerProperties, false);
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties, boolean polled) {
        BinderErrorChannel errorChannel;
        ErrorMessageStrategy errorMessageStrategy = this.getErrorMessageStrategy();
        String errorChannelName = this.errorsBaseName(destination, group, consumerProperties);
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            Object errorChannelObject = this.getApplicationContext().getBean(errorChannelName);
            Assert.isInstanceOf(SubscribableChannel.class, (Object)errorChannelObject, (String)("Error channel '" + errorChannelName + "' must be a SubscribableChannel"));
            errorChannel = (SubscribableChannel)errorChannelObject;
        } else {
            BinderErrorChannel binderErrorChannel = new BinderErrorChannel();
            binderErrorChannel.setComponentName(errorChannelName);
            errorChannel = binderErrorChannel;
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorChannelName, SubscribableChannel.class, () -> errorChannel, new BeanDefinitionCustomizer[0]);
        }
        ErrorMessageSendingRecoverer recoverer = errorMessageStrategy == null ? new ErrorMessageSendingRecoverer((MessageChannel)errorChannel) : new ErrorMessageSendingRecoverer((MessageChannel)errorChannel, errorMessageStrategy);
        String recovererBeanName = this.getErrorRecovererName(destination, group, consumerProperties);
        if (!this.getApplicationContext().containsBean(recovererBeanName)) {
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(recovererBeanName, ErrorMessageSendingRecoverer.class, () -> recoverer, new BeanDefinitionCustomizer[0]);
        }
        MessageHandler handler = polled ? this.getPolledConsumerErrorMessageHandler(destination, group, consumerProperties) : this.getErrorMessageHandler(destination, group, consumerProperties);
        MessageChannel defaultErrorChannel = null;
        if (this.getApplicationContext().containsBean("errorChannel")) {
            defaultErrorChannel = (MessageChannel)this.getApplicationContext().getBean("errorChannel", MessageChannel.class);
        }
        if (handler == null && errorChannel instanceof LastSubscriberAwareChannel) {
            handler = this.getDefaultErrorMessageHandler(errorChannel, defaultErrorChannel != null);
        }
        String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, consumerProperties);
        if (handler != null) {
            if (this.isSubscribable(errorChannel)) {
                if (!this.getApplicationContext().containsBean(errorMessageHandlerName)) {
                    MessageHandler errorHandler = handler;
                    ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorMessageHandlerName, MessageHandler.class, () -> errorHandler, new BeanDefinitionCustomizer[0]);
                    errorChannel.subscribe(handler);
                }
            } else {
                this.logger.warn((Object)("The provided errorChannel '" + errorChannelName + "' is an instance of DirectChannel, so no more subscribers could be added which may affect DLQ processing. Resolution: Configure your own errorChannel as an instance of PublishSubscribeChannel"));
            }
        }
        if (defaultErrorChannel != null) {
            if (this.isSubscribable(errorChannel)) {
                BridgeHandler errorBridge = new BridgeHandler();
                errorBridge.setOutputChannel(defaultErrorChannel);
                errorChannel.subscribe((MessageHandler)errorBridge);
                String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, consumerProperties);
                if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
                    ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorBridgeHandlerName, BridgeHandler.class, () -> errorBridge, new BeanDefinitionCustomizer[0]);
                }
            } else {
                this.logger.warn((Object)("The provided errorChannel '" + errorChannelName + "' is an instance of DirectChannel, so no more subscribers could be added and no error messages will be sent to global error channel. Resolution: Configure your own errorChannel as an instance of PublishSubscribeChannel"));
            }
        }
        return new ErrorInfrastructure(errorChannel, recoverer, handler);
    }

    private boolean isSubscribable(SubscribableChannel errorChannel) {
        if (errorChannel instanceof PublishSubscribeChannel) {
            return true;
        }
        return errorChannel instanceof AbstractSubscribableChannel ? ((AbstractSubscribableChannel)errorChannel).getSubscriberCount() == 0 : true;
    }

    private void destroyErrorInfrastructure(ProducerDestination destination) {
        String errorChannelName = this.errorsBaseName(destination);
        String errorBridgeHandlerName = this.getErrorBridgeName(destination);
        MessageHandler bridgeHandler = null;
        if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
            bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
        }
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
            if (bridgeHandler != null) {
                channel.unsubscribe(bridgeHandler);
                ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorBridgeHandlerName);
            }
            ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorChannelName);
        }
    }

    private void destroyErrorInfrastructure(ConsumerDestination destination, String group, C properties) {
        try {
            String recoverer = this.getErrorRecovererName(destination, group, properties);
            this.destroyBean(recoverer);
            String errorChannelName = this.errorsBaseName(destination, group, properties);
            String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, properties);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, properties);
            MessageHandler bridgeHandler = null;
            if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
                bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
            }
            MessageHandler handler = null;
            if (this.getApplicationContext().containsBean(errorMessageHandlerName)) {
                handler = (MessageHandler)this.getApplicationContext().getBean(errorMessageHandlerName, MessageHandler.class);
            }
            if (this.getApplicationContext().containsBean(errorChannelName)) {
                SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
                if (bridgeHandler != null) {
                    channel.unsubscribe(bridgeHandler);
                    this.destroyBean(errorBridgeHandlerName);
                }
                if (handler != null) {
                    channel.unsubscribe(handler);
                    this.destroyBean(errorMessageHandlerName);
                }
                this.destroyBean(errorChannelName);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void destroyBean(String beanName) {
        if (this.getApplicationContext().containsBeanDefinition(beanName)) {
            ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(beanName);
            ((GenericApplicationContext)this.getApplicationContext()).removeBeanDefinition(beanName);
        }
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getDefaultErrorMessageHandler(LastSubscriberAwareChannel errorChannel, boolean defaultErrorChannelPresent) {
        return new FinalRethrowingErrorMessageHandler(errorChannel, defaultErrorChannelPresent);
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return null;
    }

    protected String getErrorRecovererName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".recoverer";
    }

    protected String getErrorMessageHandlerName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".handler";
    }

    protected String getErrorBridgeName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".bridge";
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, C consumerProperties) {
        return destination.getName() + "." + group + ".errors";
    }

    protected String getErrorBridgeName(ProducerDestination destination) {
        return this.errorsBaseName(destination) + ".bridge" + destination.hashCode();
    }

    protected String errorsBaseName(ProducerDestination destination) {
        return destination.getName() + ".errors";
    }

    private Map<String, Object> doGetExtendedInfo(Object destination, Object properties) {
        LinkedHashMap<String, Object> extendedInfo = new LinkedHashMap<String, Object>();
        extendedInfo.put("bindingDestination", destination.toString());
        extendedInfo.put(properties.getClass().getSimpleName(), this.objectMapper.convertValue(properties, Map.class));
        return extendedInfo;
    }

    private void doPublishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            try {
                this.applicationEventPublisher.publishEvent(event);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed while publishing event " + event + ". From the framework perspective this is harmless and typically happens when use implement custom ApplicationListener"));
                this.logger.debug((Object)e);
            }
        }
    }

    private static /* synthetic */ SubscribableChannel lambda$registerErrorInfrastructure$6(SubscribableChannel errorChannel) {
        return errorChannel;
    }

    private static class ExpressionSerializer
    extends StdSerializer<Expression> {
        protected ExpressionSerializer(Class<Expression> t) {
            super(t);
        }

        public void serialize(Expression value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.getExpressionString());
        }
    }

    private final class SendingHandler
    extends AbstractMessageHandler
    implements Lifecycle {
        private final boolean embedHeaders;
        private final String[] embeddedHeaders;
        private final MessageHandler delegate;
        private final boolean useNativeEncoding;

        private SendingHandler(MessageHandler delegate, boolean embedHeaders, String[] headersToEmbed, boolean useNativeEncoding) {
            this.delegate = delegate;
            this.setBeanFactory((BeanFactory)AbstractMessageChannelBinder.this.getBeanFactory());
            this.embedHeaders = embedHeaders;
            this.embeddedHeaders = headersToEmbed;
            this.useNativeEncoding = useNativeEncoding;
        }

        protected void handleMessageInternal(Message<?> message) {
            Message<?> messageToSend = this.useNativeEncoding ? message : this.serializeAndEmbedHeadersIfApplicable(message);
            this.delegate.handleMessage(messageToSend);
        }

        private Message<?> serializeAndEmbedHeadersIfApplicable(Message<?> message) {
            Object payload;
            MessageValues transformed = new MessageValues(message);
            if (this.embedHeaders) {
                Object contentType = transformed.get("contentType");
                if (contentType != null) {
                    transformed.put("contentType", (Object)contentType.toString());
                }
                payload = EmbeddedHeaderUtils.embedHeaders(transformed, this.embeddedHeaders);
            } else {
                payload = transformed.getPayload();
            }
            return this.getMessageBuilderFactory().withPayload(payload).copyHeaders(transformed.getHeaders()).build();
        }

        public void start() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).start();
            }
        }

        public void stop() {
            if (this.delegate instanceof Lifecycle) {
                ((Lifecycle)this.delegate).stop();
            }
        }

        public boolean isRunning() {
            return this.delegate instanceof Lifecycle && ((Lifecycle)this.delegate).isRunning();
        }
    }

    protected static class PolledConsumerResources {
        private final MessageSource<?> source;
        private final ErrorInfrastructure errorInfrastructure;

        public PolledConsumerResources(MessageSource<?> source, ErrorInfrastructure errorInfrastructure) {
            this.source = source;
            this.errorInfrastructure = errorInfrastructure;
        }

        MessageSource<?> getSource() {
            return this.source;
        }

        ErrorInfrastructure getErrorInfrastructure() {
            return this.errorInfrastructure;
        }
    }

    private static final class EmbeddedHeadersChannelInterceptor
    implements ChannelInterceptor {
        protected final Log logger;

        EmbeddedHeadersChannelInterceptor(Log logger) {
            this.logger = logger;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (message.getPayload() instanceof byte[] && !message.getHeaders().containsKey((Object)"scst_nativeHeadersPresent") && EmbeddedHeaderUtils.mayHaveEmbeddedHeaders((byte[])message.getPayload())) {
                MessageValues messageValues;
                try {
                    messageValues = EmbeddedHeaderUtils.extractHeaders(message, true);
                }
                catch (Exception e) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)EmbeddedHeaderUtils.decodeExceptionMessage(message), (Throwable)e);
                    }
                    messageValues = new MessageValues(message);
                }
                return messageValues.toMessage();
            }
            return message;
        }
    }

    protected static class ErrorInfrastructure {
        private final SubscribableChannel errorChannel;
        private final ErrorMessageSendingRecoverer recoverer;
        private final MessageHandler handler;

        ErrorInfrastructure(SubscribableChannel errorChannel, ErrorMessageSendingRecoverer recoverer, MessageHandler handler) {
            this.errorChannel = errorChannel;
            this.recoverer = recoverer;
            this.handler = handler;
        }

        public SubscribableChannel getErrorChannel() {
            return this.errorChannel;
        }

        public ErrorMessageSendingRecoverer getRecoverer() {
            return this.recoverer;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }
    }
}

