/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.IdentifierFactory;
import org.springframework.data.cassandra.core.mapping.UserDefinedType;
import org.springframework.data.util.TypeInformation;

public class CassandraUserTypePersistentEntity<T>
extends BasicCassandraPersistentEntity<T> {
    public CassandraUserTypePersistentEntity(TypeInformation<T> typeInformation, CassandraPersistentEntityMetadataVerifier verifier) {
        super(typeInformation, verifier);
    }

    @Override
    protected CqlIdentifier determineTableName() {
        UserDefinedType annotation = (UserDefinedType)this.findAnnotation(UserDefinedType.class);
        if (annotation != null) {
            return this.determineName(annotation.value(), annotation.forceQuote());
        }
        return IdentifierFactory.create(this.getNamingStrategy().getUserDefinedTypeName(this), false);
    }

    @Override
    public boolean isUserDefinedType() {
        return true;
    }
}

