/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private CassandraOperations cassandraOperations;

    public CassandraRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        Assert.state((this.cassandraOperations != null ? 1 : 0) != 0, (String)"CassandraOperations must not be null");
        return new CassandraRepositoryFactory(this.cassandraOperations);
    }

    public void setCassandraTemplate(CassandraTemplate cassandraTemplate) {
        this.cassandraOperations = cassandraTemplate;
        this.setMappingContext((MappingContext)cassandraTemplate.getConverter().getMappingContext());
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cassandraOperations, (String)"CassandraOperations must not be null!");
    }
}

