/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import org.springframework.data.cassandra.core.convert.CassandraValueProvider;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TupleValueProvider
implements CassandraValueProvider {
    private final CodecRegistry codecRegistry;
    private final SpELExpressionEvaluator evaluator;
    private final TupleValue tupleValue;

    public TupleValueProvider(TupleValue tupleValue, SpELExpressionEvaluator evaluator) {
        Assert.notNull((Object)tupleValue, (String)"TupleValue must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        this.tupleValue = tupleValue;
        this.codecRegistry = tupleValue.codecRegistry();
        this.evaluator = evaluator;
    }

    @Nullable
    public <T> T getPropertyValue(CassandraPersistentProperty property) {
        String spelExpression = property.getSpelExpression();
        if (spelExpression != null) {
            return (T)this.evaluator.evaluate(spelExpression);
        }
        int ordinal = property.getRequiredOrdinal();
        DataType elementType = (DataType)this.tupleValue.getType().getComponentTypes().get(ordinal);
        return (T)this.tupleValue.get(ordinal, this.codecRegistry.codecFor(elementType));
    }

    @Override
    public boolean hasProperty(CassandraPersistentProperty property) {
        return this.tupleValue.getType().getComponentTypes().size() >= property.getRequiredOrdinal();
    }

    @Override
    public Object getSource() {
        return this.tupleValue;
    }
}

