/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.Indexed;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.core.mapping.PrimaryKeyColumn;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.VerifierMappingExceptions;
import org.springframework.data.mapping.MappingException;

public class BasicCassandraPersistentEntityMetadataVerifier
implements CassandraPersistentEntityMetadataVerifier {
    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface() || !entity.isAnnotationPresent(Table.class)) {
            return;
        }
        ArrayList<MappingException> exceptions = new ArrayList<MappingException>();
        ArrayList idProperties = new ArrayList();
        ArrayList partitionKeyColumns = new ArrayList();
        ArrayList primaryKeyColumns = new ArrayList();
        if (entity.isAnnotationPresent(Indexed.class)) {
            exceptions.add(new MappingException("@Indexed cannot be used on entity classes"));
        }
        if (entity.isCompositePrimaryKey()) {
            exceptions.add(new MappingException(String.format("Entity cannot be of type @%s and @%s", Table.class.getSimpleName(), PrimaryKeyClass.class.getSimpleName())));
        }
        entity.forEach(property -> {
            if (property.isIdProperty()) {
                idProperties.add(property);
            } else if (property.isClusterKeyColumn()) {
                primaryKeyColumns.add(property);
            } else if (property.isPartitionKeyColumn()) {
                partitionKeyColumns.add(property);
                primaryKeyColumns.add(property);
            }
        });
        if (primaryKeyColumns.isEmpty() && idProperties.size() != 1) {
            exceptions.add(new MappingException(String.format("@%s types must have only one primary attribute, if any; Found %s", Table.class.getSimpleName(), idProperties.size())));
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
        if (!idProperties.isEmpty() && !primaryKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("@%s types must not define both @%s and @%s properties", Table.class.getSimpleName(), Id.class.getSimpleName(), PrimaryKeyColumn.class.getSimpleName())));
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
        if (!primaryKeyColumns.isEmpty() && partitionKeyColumns.isEmpty()) {
            exceptions.add(new MappingException(String.format("At least one of the @%s annotations must have a type of PARTITIONED", PrimaryKeyColumn.class.getSimpleName())));
        }
        if (!exceptions.isEmpty()) {
            BasicCassandraPersistentEntityMetadataVerifier.fail(entity, exceptions);
        }
    }

    private static void fail(CassandraPersistentEntity<?> entity, List<MappingException> exceptions) {
        throw new VerifierMappingExceptions(entity, exceptions);
    }
}

