/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.ParsingUtils;
import org.springframework.data.cassandra.config.SortedResourcesFactoryBean;
import org.springframework.data.cassandra.core.cql.session.init.CompositeKeyspacePopulator;
import org.springframework.data.cassandra.core.cql.session.init.ResourceKeyspacePopulator;
import org.springframework.data.cassandra.core.cql.session.init.SessionFactoryInitializer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class InitializeKeyspaceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    InitializeKeyspaceBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SessionFactoryInitializer.class);
        if (element.hasAttribute("session-factory-ref")) {
            ParsingUtils.addRequiredPropertyReference(builder, "session", element, "session-factory-ref");
        }
        builder.addPropertyValue("enabled", (Object)element.getAttribute("enabled"));
        InitializeKeyspaceBeanDefinitionParser.parseKeyspacePopulator(element, builder);
        builder.getRawBeanDefinition().setSource((Object)element);
        return builder.getBeanDefinition();
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    public static void parseKeyspacePopulator(Element element, BeanDefinitionBuilder builder) {
        List scripts = DomUtils.getChildElementsByTagName((Element)element, (String)"script");
        if (!scripts.isEmpty()) {
            builder.addPropertyValue("keyspacePopulator", (Object)InitializeKeyspaceBeanDefinitionParser.createKeyspacePopulator(element, scripts, "INIT"));
            builder.addPropertyValue("keyspaceCleaner", (Object)InitializeKeyspaceBeanDefinitionParser.createKeyspacePopulator(element, scripts, "DESTROY"));
        }
    }

    private static BeanDefinition createKeyspacePopulator(Element element, List<Element> scripts, String execution) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CompositeKeyspacePopulator.class);
        boolean ignoreFailedDrops = element.getAttribute("ignore-failures").equals("DROPS");
        boolean continueOnError = element.getAttribute("ignore-failures").equals("ALL");
        ManagedList delegates = new ManagedList();
        for (Element scriptElement : scripts) {
            String separator;
            String executionAttr = scriptElement.getAttribute("execution");
            if (!StringUtils.hasText((String)executionAttr)) {
                executionAttr = "INIT";
            }
            if (!execution.equals(executionAttr)) continue;
            BeanDefinitionBuilder delegate = BeanDefinitionBuilder.genericBeanDefinition(ResourceKeyspacePopulator.class);
            delegate.addPropertyValue("ignoreFailedDrops", (Object)ignoreFailedDrops);
            delegate.addPropertyValue("continueOnError", (Object)continueOnError);
            BeanDefinitionBuilder resourcesFactory = BeanDefinitionBuilder.genericBeanDefinition(SortedResourcesFactoryBean.class);
            resourcesFactory.addConstructorArgValue((Object)new TypedStringValue(scriptElement.getAttribute("location")));
            delegate.addPropertyValue("scripts", (Object)resourcesFactory.getBeanDefinition());
            if (StringUtils.hasLength((String)scriptElement.getAttribute("encoding"))) {
                delegate.addPropertyValue("cqlScriptEncoding", (Object)new TypedStringValue(scriptElement.getAttribute("encoding")));
            }
            if ((separator = InitializeKeyspaceBeanDefinitionParser.getSeparator(element, scriptElement)) != null) {
                delegate.addPropertyValue("separator", (Object)new TypedStringValue(separator));
            }
            delegates.add((Object)delegate.getBeanDefinition());
        }
        builder.addPropertyValue("populators", (Object)delegates);
        return builder.getBeanDefinition();
    }

    @Nullable
    private static String getSeparator(Element element, Element scriptElement) {
        String scriptSeparator = scriptElement.getAttribute("separator");
        if (StringUtils.hasLength((String)scriptSeparator)) {
            return scriptSeparator;
        }
        String elementSeparator = element.getAttribute("separator");
        if (StringUtils.hasLength((String)elementSeparator)) {
            return elementSeparator;
        }
        return null;
    }
}

