/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.support;

import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.query.OptionsBuilder;

public class PseudoArgs<OPTS> {
    private final OPTS options;
    private final String scopeName;
    private final String collectionName;

    public PseudoArgs(String scopeName, String collectionName, OPTS options) {
        this.options = options;
        this.scopeName = scopeName;
        this.collectionName = collectionName;
    }

    public PseudoArgs(ReactiveCouchbaseTemplate template, String scope, String collection, OPTS options, Class<?> domainType) {
        String scopeForQuery = null;
        String collectionForQuery = null;
        Object optionsForQuery = null;
        PseudoArgs<?> threadLocal = template.getPseudoArgs();
        template.setPseudoArgs(null);
        if (threadLocal != null) {
            scopeForQuery = threadLocal.getScope();
            collectionForQuery = threadLocal.getCollection();
            optionsForQuery = threadLocal.getOptions();
        }
        scopeForQuery = OptionsBuilder.fromFirst(null, scopeForQuery, scope, OptionsBuilder.getScopeFrom(domainType));
        collectionForQuery = OptionsBuilder.fromFirst(null, collectionForQuery, collection, OptionsBuilder.getCollectionFrom(domainType));
        optionsForQuery = OptionsBuilder.fromFirst(null, options, optionsForQuery);
        if (collectionForQuery != null && scopeForQuery == null) {
            scopeForQuery = template.getCouchbaseClientFactory().getScope().name();
        }
        if ((scopeForQuery == null || "_default".equals(scopeForQuery)) && (collectionForQuery == null || "_default".equals(collectionForQuery))) {
            collectionForQuery = null;
            scopeForQuery = null;
        }
        this.scopeName = scopeForQuery;
        this.collectionName = collectionForQuery;
        this.options = optionsForQuery;
    }

    public OPTS getOptions() {
        return this.options;
    }

    public String getScope() {
        return this.scopeName;
    }

    public String getCollection() {
        return this.collectionName;
    }

    public String toString() {
        return "scope: " + this.getScope() + " collection: " + this.getCollection() + " options: " + this.getOptions();
    }
}

