/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.query.QueryScanConsistency;
import java.lang.reflect.AnnotatedElement;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.repository.Collection;
import org.springframework.data.couchbase.repository.ScanConsistency;
import org.springframework.data.couchbase.repository.Scope;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadata;

public class CouchbaseRepositoryBase<T, ID> {
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private final Class<?> repositoryInterface;
    private CrudMethodMetadata crudMethodMetadata;

    public CouchbaseRepositoryBase(CouchbaseEntityInformation<T, String> entityInformation, Class<?> repositoryInterface) {
        this.entityInformation = entityInformation;
        this.repositoryInterface = repositoryInterface;
    }

    public CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    Class<T> getJavaType() {
        return this.getEntityInformation().getJavaType();
    }

    <S extends T> String getId(S entity) {
        return (String)this.getEntityInformation().getId(entity);
    }

    protected String getScope() {
        String fromAnnotation = OptionsBuilder.annotationString(Scope.class, "_default", new AnnotatedElement[]{this.getJavaType(), this.repositoryInterface});
        String fromMetadata = this.crudMethodMetadata.getScope();
        return OptionsBuilder.fromFirst("_default", fromMetadata, fromAnnotation);
    }

    protected String getCollection() {
        String fromAnnotation = OptionsBuilder.annotationString(Collection.class, "_default", new AnnotatedElement[]{this.getJavaType(), this.repositoryInterface});
        String fromMetadata = this.crudMethodMetadata.getCollection();
        return OptionsBuilder.fromFirst("_default", fromMetadata, fromAnnotation);
    }

    QueryScanConsistency buildQueryScanConsistency() {
        ScanConsistency sc = this.crudMethodMetadata.getScanConsistency();
        QueryScanConsistency fromMeta = sc != null ? sc.query() : null;
        QueryScanConsistency fromAnnotation = OptionsBuilder.annotationAttribute(ScanConsistency.class, "query", QueryScanConsistency.NOT_BOUNDED, new AnnotatedElement[]{this.getJavaType(), this.repositoryInterface});
        return OptionsBuilder.fromFirst(QueryScanConsistency.NOT_BOUNDED, fromMeta, fromAnnotation);
    }

    void setRepositoryMethodMetadata(CrudMethodMetadata crudMethodMetadata) {
        this.crudMethodMetadata = crudMethodMetadata;
    }
}

