/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.couchbase.document.CouchbaseDocumentSerializer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.QueryCriteriaDefinition;
import org.springframework.data.couchbase.repository.support.DBRef;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringDataCouchbaseSerializer
extends CouchbaseDocumentSerializer {
    private static final String ID_KEY = "_id";
    private static final Set<PathType> PATH_TYPES;
    private final CouchbaseConverter converter;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;

    public SpringDataCouchbaseSerializer(CouchbaseConverter converter) {
        Assert.notNull((Object)converter, (String)"CouchbaseConverter must not be null!");
        this.mappingContext = converter.getMappingContext();
        this.converter = converter;
    }

    @Override
    public Object visit(Constant<?> expr, Void context) {
        if (!ClassUtils.isAssignable(Enum.class, (Class)expr.getType())) {
            return super.visit(expr, context);
        }
        return this.converter.convertForWriteIfNeeded(expr.getConstant());
    }

    @Override
    protected String getKeyForPath(Path<?> expr, PathMetadata metadata) {
        if (!metadata.getPathType().equals((Object)PathType.PROPERTY)) {
            return super.getKeyForPath(expr, metadata);
        }
        Path parent = metadata.getParent();
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(parent.getType());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)entity.getPersistentProperty(metadata.getName());
        return property == null ? super.getKeyForPath(expr, metadata) : property.getFieldName();
    }

    @Override
    protected QueryCriteriaDefinition asDocument(@Nullable String key, @Nullable Object value) {
        value = value instanceof Optional ? ((Optional)value).orElse(null) : value;
        return super.asDocument(key, value instanceof Pattern ? value : this.converter.convertForWriteIfNeeded(value));
    }

    @Override
    protected boolean isReference(@Nullable Path<?> path) {
        CouchbasePersistentProperty property = this.getPropertyForPotentialDbRef(path);
        return property == null ? false : property.isAssociation();
    }

    @Override
    protected DBRef asReference(@Nullable Object constant) {
        return this.asReference(constant, null);
    }

    protected DBRef asReference(Object constant, Path<?> path) {
        return null;
    }

    @Override
    protected String asDBKey(@Nullable Operation<?> expr, int index) {
        Expression arg = expr.getArg(index);
        String key = super.asDBKey(expr, index);
        if (!(arg instanceof Path)) {
            return key;
        }
        Path path = (Path)arg;
        if (!this.isReference(path)) {
            return key;
        }
        CouchbasePersistentProperty property = this.getPropertyFor(path);
        return property.isIdProperty() ? key.replaceAll("._id$", "") : key;
    }

    protected Object convert(@Nullable Path<?> path, @Nullable Constant<?> constant) {
        if (!this.isReference(path)) {
            return null;
        }
        CouchbasePersistentProperty property = this.getPropertyFor(path);
        return property.isIdProperty() ? this.asReference(constant.getConstant(), path.getMetadata().getParent()) : this.asReference(constant.getConstant(), path);
    }

    @Nullable
    private CouchbasePersistentProperty getPropertyFor(Path<?> path) {
        Path parent = path.getMetadata().getParent();
        if (parent == null || !PATH_TYPES.contains(path.getMetadata().getPathType())) {
            return null;
        }
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getPersistentEntity(parent.getType());
        return entity != null ? (CouchbasePersistentProperty)entity.getPersistentProperty(path.getMetadata().getName()) : null;
    }

    private CouchbasePersistentProperty getPropertyForPotentialDbRef(Path<?> path) {
        if (path == null) {
            return null;
        }
        CouchbasePersistentProperty property = this.getPropertyFor(path);
        PathMetadata metadata = path.getMetadata();
        if (property != null && property.isIdProperty() && metadata != null && metadata.getParent() != null) {
            return this.getPropertyFor(metadata.getParent());
        }
        return property;
    }

    static {
        HashSet<PathType> pathTypes = new HashSet<PathType>();
        pathTypes.add(PathType.VARIABLE);
        pathTypes.add(PathType.PROPERTY);
        PATH_TYPES = Collections.unmodifiableSet(pathTypes);
    }
}

