/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.core.ExecutableMutateInByIdOperation;
import org.springframework.data.couchbase.core.NonReactiveSupportWrapper;
import org.springframework.data.couchbase.core.ReactiveMutateInByIdOperationSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.util.Assert;

public class ExecutableMutateInByIdOperationSupport
implements ExecutableMutateInByIdOperation {
    private final CouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ExecutableMutateInByIdOperationSupport.class);

    public ExecutableMutateInByIdOperationSupport(CouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ExecutableMutateInByIdOperation.ExecutableMutateInById<T> mutateInById(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableMutateInByIdSupport<T>(this.template, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, OptionsBuilder.getPersistTo(domainType), OptionsBuilder.getReplicateTo(domainType), OptionsBuilder.getDurabilityLevel(domainType, this.template.getConverter()), null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false);
    }

    static class ExecutableMutateInByIdSupport<T>
    implements ExecutableMutateInByIdOperation.ExecutableMutateInById<T> {
        private final CouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final MutateInOptions options;
        private final PersistTo persistTo;
        private final ReplicateTo replicateTo;
        private final DurabilityLevel durabilityLevel;
        private final Duration expiry;
        private final boolean provideCas;
        private final List<String> removePaths = new ArrayList<String>();
        private final List<String> upsertPaths = new ArrayList<String>();
        private final List<String> insertPaths = new ArrayList<String>();
        private final List<String> replacePaths = new ArrayList<String>();
        private final ReactiveMutateInByIdOperationSupport.ReactiveMutateInByIdSupport<T> reactiveSupport;

        ExecutableMutateInByIdSupport(CouchbaseTemplate template, Class<T> domainType, String scope, String collection, MutateInOptions options, PersistTo persistTo, ReplicateTo replicateTo, DurabilityLevel durabilityLevel, Duration expiry, List<String> removePaths, List<String> upsertPaths, List<String> insertPaths, List<String> replacePaths, boolean provideCas) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.persistTo = persistTo;
            this.replicateTo = replicateTo;
            this.durabilityLevel = durabilityLevel;
            this.expiry = expiry;
            this.removePaths.addAll(removePaths);
            this.upsertPaths.addAll(upsertPaths);
            this.insertPaths.addAll(insertPaths);
            this.replacePaths.addAll(replacePaths);
            this.provideCas = provideCas;
            this.reactiveSupport = new ReactiveMutateInByIdOperationSupport.ReactiveMutateInByIdSupport<T>(template.reactive(), domainType, scope, collection, options, persistTo, replicateTo, durabilityLevel, expiry, new NonReactiveSupportWrapper(template.support()), removePaths, upsertPaths, insertPaths, replacePaths, provideCas);
        }

        @Override
        public T one(T object) {
            return (T)this.reactiveSupport.one(object).block();
        }

        @Override
        public Collection<? extends T> all(Collection<? extends T> objects) {
            return (Collection)this.reactiveSupport.all(objects).collectList().block();
        }

        @Override
        public ExecutableMutateInByIdOperation.TerminatingMutateInById<T> withOptions(MutateInOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> inCollection(String collection) {
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, collection != null ? collection : this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdInCollection<T> inScope(String scope) {
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, scope != null ? scope : this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdInScope<T> withDurability(DurabilityLevel durabilityLevel) {
            Assert.notNull((Object)durabilityLevel, (String)"Durability Level must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdInScope<T> withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
            Assert.notNull((Object)persistTo, (String)"PersistTo must not be null.");
            Assert.notNull((Object)replicateTo, (String)"ReplicateTo must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, persistTo, replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> withExpiry(Duration expiry) {
            Assert.notNull((Object)expiry, (String)"expiry must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> withRemovePaths(String ... removePaths) {
            Assert.notNull((Object)removePaths, (String)"removePaths path must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, Arrays.asList(removePaths), this.upsertPaths, this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> withUpsertPaths(String ... upsertPaths) {
            Assert.notNull((Object)upsertPaths, (String)"upsertPaths path must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, Arrays.asList(upsertPaths), this.insertPaths, this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> withInsertPaths(String ... insertPaths) {
            Assert.notNull((Object)insertPaths, (String)"insertPaths path must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, Arrays.asList(insertPaths), this.replacePaths, this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithDurability<T> withReplacePaths(String ... replacePaths) {
            Assert.notNull((Object)replacePaths, (String)"replacePaths path must not be null.");
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, Arrays.asList(replacePaths), this.provideCas);
        }

        @Override
        public ExecutableMutateInByIdOperation.MutateInByIdWithPaths<T> withCasProvided() {
            return new ExecutableMutateInByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.persistTo, this.replicateTo, this.durabilityLevel, this.expiry, this.removePaths, this.upsertPaths, this.insertPaths, this.replacePaths, true);
        }
    }
}

