/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.mapping.event;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.couchbase.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.AfterSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.couchbase.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.couchbase.core.mapping.event.CouchbaseMappingEvent;
import org.springframework.util.Assert;

public class AuditingEventListener
implements ApplicationListener<CouchbaseMappingEvent<Object>> {
    private final ObjectFactory<Object> auditingHandlerFactory;
    private static final Logger LOG = LoggerFactory.getLogger(AuditingEventListener.class);

    public AuditingEventListener() {
        this.auditingHandlerFactory = null;
    }

    public AuditingEventListener(ObjectFactory<Object> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"auditingHandlerFactory must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    public void onApplicationEvent(CouchbaseMappingEvent<Object> event) {
        if (event instanceof BeforeConvertEvent) {
            IsNewAwareAuditingHandler h;
            IsNewAwareAuditingHandler isNewAwareAuditingHandler = h = this.auditingHandlerFactory != null && this.auditingHandlerFactory.getObject() instanceof IsNewAwareAuditingHandler ? (IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject() : null;
            if (this.auditingHandlerFactory != null && h == null && LOG.isWarnEnabled()) {
                LOG.warn("event:{} source:{} auditingHandler is not an IsNewAwareAuditingHandler: {}", new Object[]{((Object)event).getClass().getSimpleName(), event.getSource(), this.auditingHandlerFactory.getObject()});
            }
            if (h != null) {
                Optional.ofNullable(event.getSource()).ifPresent(it -> h.markAudited(it));
            }
        }
        if (event instanceof BeforeSaveEvent) {
            // empty if block
        }
        if (event instanceof AfterSaveEvent) {
            // empty if block
        }
        if (event instanceof BeforeDeleteEvent) {
            // empty if block
        }
        if (event instanceof AfterDeleteEvent) {
            // empty if block
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} {}", (Object)((Object)event).getClass().getSimpleName(), event.getSource());
        }
    }
}

