/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.transactions.TransactionResult;
import com.couchbase.client.java.transactions.config.TransactionOptions;
import com.couchbase.client.java.transactions.error.TransactionCommitAmbiguousException;
import com.couchbase.client.java.transactions.error.TransactionFailedException;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.data.couchbase.transaction.CouchbaseResourceOwner;
import org.springframework.data.couchbase.transaction.CouchbaseTransactionStatus;
import org.springframework.data.couchbase.transaction.error.TransactionRollbackRequestedException;
import org.springframework.data.couchbase.transaction.error.TransactionSystemAmbiguousException;
import org.springframework.data.couchbase.transaction.error.TransactionSystemUnambiguousException;
import org.springframework.lang.Nullable;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.ReactiveTransaction;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CouchbaseCallbackTransactionManager
implements CallbackPreferringPlatformTransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouchbaseCallbackTransactionManager.class);
    private final CouchbaseClientFactory couchbaseClientFactory;
    @Nullable
    private TransactionOptions options;

    public CouchbaseCallbackTransactionManager(CouchbaseClientFactory couchbaseClientFactory) {
        this(couchbaseClientFactory, null);
    }

    public CouchbaseCallbackTransactionManager(CouchbaseClientFactory couchbaseClientFactory, @Nullable TransactionOptions options) {
        this.couchbaseClientFactory = couchbaseClientFactory;
        this.options = options != null ? options : TransactionOptions.transactionOptions();
    }

    public <T> T execute(TransactionDefinition definition, TransactionCallback<T> callback) throws TransactionException {
        boolean isInExistingTransaction = ((Optional)TransactionalSupport.checkForTransactionInThreadLocalStorage().block()).isPresent();
        boolean createNewTransaction = this.handlePropagation(definition, isInExistingTransaction);
        this.setOptionsFromDefinition(definition);
        if (createNewTransaction) {
            return this.executeNewTransaction(callback);
        }
        return (T)callback.doInTransaction(null);
    }

    @Stability.Internal
    <T> Flux<T> executeReactive(TransactionDefinition definition, org.springframework.transaction.reactive.TransactionCallback<T> callback) {
        CouchbaseResourceHolder couchbaseResourceHolder = new CouchbaseResourceHolder(null, CouchbaseCallbackTransactionManager.getSecurityContext());
        return TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMapMany(isInTransaction -> {
            boolean isInExistingTransaction = isInTransaction.isPresent();
            boolean createNewTransaction = this.handlePropagation(definition, isInExistingTransaction);
            this.setOptionsFromDefinition(definition);
            if (createNewTransaction) {
                return this.executeNewReactiveTransaction(callback);
            }
            return Mono.error((Throwable)new UnsupportedOperationException("Unsupported operation"));
        }).contextWrite(ctx -> ctx.put(CouchbaseResourceHolder.class, (Object)couchbaseResourceHolder));
    }

    private <T> T executeNewTransaction(TransactionCallback<T> callback) {
        AtomicReference execResult = new AtomicReference();
        CouchbaseResourceHolder couchbaseResourceHolder = new CouchbaseResourceHolder(null, CouchbaseCallbackTransactionManager.getSecurityContext());
        try {
            TransactionResult ignored = this.couchbaseClientFactory.getCluster().transactions().run(ctx -> {
                CouchbaseCallbackTransactionManager.setSecurityContext(couchbaseResourceHolder.getSecurityContext());
                CouchbaseTransactionStatus status = new CouchbaseTransactionStatus(ctx, true, false, false, true, null);
                Object res = callback.doInTransaction((TransactionStatus)status);
                if (res instanceof Mono || res instanceof Flux) {
                    throw new UnsupportedOperationException("Return type is Mono or Flux, indicating a reactive transaction is being performed in a blocking way.  A potential cause is the CouchbaseTransactionInterceptor is not in use.");
                }
                execResult.set(res);
                if (status.isRollbackOnly()) {
                    throw new TransactionRollbackRequestedException("TransactionStatus.isRollbackOnly() is set");
                }
            }, this.options);
            return (T)execResult.get();
        }
        catch (RuntimeException ex) {
            throw CouchbaseCallbackTransactionManager.convert(ex);
        }
    }

    private static RuntimeException convert(RuntimeException ex) {
        if (ex instanceof TransactionCommitAmbiguousException) {
            return new TransactionSystemAmbiguousException((TransactionCommitAmbiguousException)ex);
        }
        if (ex instanceof TransactionFailedException) {
            return new TransactionSystemUnambiguousException((TransactionFailedException)ex);
        }
        return ex;
    }

    private <T> Flux<T> executeNewReactiveTransaction(org.springframework.transaction.reactive.TransactionCallback<T> callback) {
        ArrayList out = new ArrayList();
        return this.couchbaseClientFactory.getCluster().reactive().transactions().run(ctx -> Mono.defer(() -> {
            ReactiveTransaction status = new ReactiveTransaction(){
                boolean rollbackOnly = false;

                public boolean isNewTransaction() {
                    return true;
                }

                public void setRollbackOnly() {
                    this.rollbackOnly = true;
                }

                public boolean isRollbackOnly() {
                    return this.rollbackOnly;
                }

                public boolean isCompleted() {
                    return false;
                }
            };
            return CouchbaseResourceOwner.get().map(cbrh -> cbrh.map(c -> CouchbaseCallbackTransactionManager.setSecurityContext(c.getSecurityContext()))).flatMap(ignore -> Flux.from((Publisher)callback.doInTransaction(status)).doOnNext(v -> out.add(v)).then(Mono.defer(() -> {
                if (status.isRollbackOnly()) {
                    return Mono.error((Throwable)((Object)new TransactionRollbackRequestedException("TransactionStatus.isRollbackOnly() is set")));
                }
                return Mono.empty();
            })));
        }), this.options).thenMany((Publisher)Flux.defer(() -> Flux.fromIterable((Iterable)out))).onErrorMap(ex -> {
            if (ex instanceof RuntimeException) {
                return CouchbaseCallbackTransactionManager.convert((RuntimeException)ex);
            }
            return ex;
        });
    }

    private Boolean handlePropagation(TransactionDefinition definition, boolean isExistingTransaction) {
        LOGGER.trace("Deciding propagation behaviour from {} and {}", (Object)definition.getPropagationBehavior(), (Object)isExistingTransaction);
        switch (definition.getPropagationBehavior()) {
            case 0: {
                return !isExistingTransaction;
            }
            case 1: {
                throw new UnsupportedOperationException("Propagation level 'support' has been specified which is not supported");
            }
            case 2: {
                if (!isExistingTransaction) {
                    throw new IllegalTransactionStateException("Propagation level 'mandatory' is specified but not in an active transaction");
                }
                return false;
            }
            case 3: {
                throw new UnsupportedOperationException("Propagation level 'requires_new' has been specified which is not currently supported");
            }
            case 4: {
                throw new UnsupportedOperationException("Propagation level 'not_supported' has been specified which is not supported");
            }
            case 5: {
                if (isExistingTransaction) {
                    throw new IllegalTransactionStateException("Existing transaction found for transaction marked with propagation 'never'");
                }
                return true;
            }
            case 6: {
                if (isExistingTransaction) {
                    throw new UnsupportedOperationException("Propagation level 'nested' has been specified which is not supported");
                }
                return true;
            }
        }
        throw new UnsupportedOperationException("Unknown propagation level " + definition.getPropagationBehavior() + " has been specified");
    }

    private void setOptionsFromDefinition(TransactionDefinition definition) {
        if (definition != null) {
            if (definition.getTimeout() != -1) {
                if (this.options == null) {
                    this.options = TransactionOptions.transactionOptions();
                }
                this.options = this.options.timeout(Duration.ofSeconds(definition.getTimeout()));
            }
            if (definition.getIsolationLevel() != -1 && definition.getIsolationLevel() != 2) {
                throw new IllegalArgumentException("Couchbase Transactions run at Read Committed isolation - other isolation levels are not supported");
            }
        }
    }

    public TransactionStatus getTransaction(@Nullable TransactionDefinition definition) throws TransactionException {
        throw new UnsupportedOperationException("Direct programmatic use of the Couchbase PlatformTransactionManager is not supported");
    }

    public void commit(TransactionStatus ignored) throws TransactionException {
        throw new UnsupportedOperationException("Direct programmatic use of the Couchbase PlatformTransactionManager is not supported");
    }

    public void rollback(TransactionStatus ignored) throws TransactionException {
        throw new UnsupportedOperationException("Direct programmatic use of the Couchbase PlatformTransactionManager is not supported");
    }

    private static Object getSecurityContext() {
        try {
            Class<?> securityContextHolderClass = Class.forName("org.springframework.security.core.context.SecurityContextHolder");
            return securityContextHolderClass.getMethod("getContext", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static <S> S setSecurityContext(S sc) {
        try {
            Class<?> securityContextHolder = Class.forName("org.springframework.security.core.context.SecurityContext");
            Class<?> securityContextHolderClass = Class.forName("org.springframework.security.core.context.SecurityContextHolder");
            securityContextHolderClass.getMethod("setContext", securityContextHolder).invoke(null, sc);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return sc;
    }
}

