/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.mongodb.core.MongoAdmin;
import org.springframework.data.mongodb.monitor.AssertMetrics;
import org.springframework.data.mongodb.monitor.BackgroundFlushingMetrics;
import org.springframework.data.mongodb.monitor.BtreeIndexCounters;
import org.springframework.data.mongodb.monitor.ConnectionMetrics;
import org.springframework.data.mongodb.monitor.GlobalLockMetrics;
import org.springframework.data.mongodb.monitor.MemoryMetrics;
import org.springframework.data.mongodb.monitor.OperationCounters;
import org.springframework.data.mongodb.monitor.ServerInfo;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoJmxParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String name = element.getAttribute("mongo-ref");
        if (!StringUtils.hasText((String)name)) {
            name = "mongo";
        }
        this.registerJmxComponents(name, element, parserContext);
        return null;
    }

    protected void registerJmxComponents(String mongoRefName, Element element, ParserContext parserContext) {
        Object eleSource = parserContext.extractSource((Object)element);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), eleSource);
        this.createBeanDefEntry(AssertMetrics.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(BackgroundFlushingMetrics.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(BtreeIndexCounters.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(ConnectionMetrics.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(GlobalLockMetrics.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(MemoryMetrics.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(OperationCounters.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(ServerInfo.class, compositeDef, mongoRefName, eleSource, parserContext);
        this.createBeanDefEntry(MongoAdmin.class, compositeDef, mongoRefName, eleSource, parserContext);
        parserContext.registerComponent((ComponentDefinition)compositeDef);
    }

    protected void createBeanDefEntry(Class<?> clazz, CompositeComponentDefinition compositeDef, String mongoRefName, Object eleSource, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        builder.getRawBeanDefinition().setSource(eleSource);
        builder.addConstructorArgReference(mongoRefName);
        AbstractBeanDefinition assertDef = builder.getBeanDefinition();
        String assertName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)assertDef);
        compositeDef.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)assertDef, assertName));
    }
}

