/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.BSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.AbstractMongoConverter;
import org.springframework.data.mongodb.core.convert.DBObjectPropertyAccessor;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingMongoConverter
extends AbstractMongoConverter
implements ApplicationContextAware {
    protected static final Logger log = LoggerFactory.getLogger(MappingMongoConverter.class);
    protected final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    protected final SpelExpressionParser spelExpressionParser = new SpelExpressionParser();
    protected final MongoDbFactory mongoDbFactory;
    protected final QueryMapper idMapper;
    protected ApplicationContext applicationContext;
    protected boolean useFieldAccessOnly = true;
    protected MongoTypeMapper typeMapper;
    protected String mapKeyDotReplacement = null;
    private SpELContext spELContext;

    public MappingMongoConverter(MongoDbFactory mongoDbFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(ConversionServiceFactory.createDefaultConversionService());
        Assert.notNull((Object)mongoDbFactory);
        Assert.notNull(mappingContext);
        this.mongoDbFactory = mongoDbFactory;
        this.mappingContext = mappingContext;
        this.typeMapper = new DefaultMongoTypeMapper("_class", mappingContext);
        this.idMapper = new QueryMapper(this);
        this.spELContext = new SpELContext((PropertyAccessor)DBObjectPropertyAccessor.INSTANCE);
    }

    public void setTypeMapper(MongoTypeMapper typeMapper) {
        this.typeMapper = typeMapper == null ? new DefaultMongoTypeMapper("_class", this.mappingContext) : typeMapper;
    }

    public void setMapKeyDotReplacement(String mapKeyDotReplacement) {
        this.mapKeyDotReplacement = mapKeyDotReplacement;
    }

    public MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public void setUseFieldAccessOnly(boolean useFieldAccessOnly) {
        this.useFieldAccessOnly = useFieldAccessOnly;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
    }

    public <S> S read(Class<S> clazz, DBObject dbo) {
        return this.read(ClassTypeInformation.from(clazz), dbo);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo) {
        return this.read(type, dbo, null);
    }

    protected <S> S read(TypeInformation<S> type, DBObject dbo, Object parent) {
        if (null == dbo) {
            return null;
        }
        TypeInformation typeToUse = this.typeMapper.readType(dbo, type);
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(dbo.getClass(), rawType)) {
            return (S)this.conversionService.convert((Object)dbo, rawType);
        }
        if (DBObject.class.isAssignableFrom(rawType)) {
            return (S)dbo;
        }
        if (typeToUse.isCollectionLike() && dbo instanceof BasicDBList) {
            return (S)this.readCollectionOrArray(typeToUse, (BasicDBList)dbo, parent);
        }
        if (typeToUse.isMap()) {
            return (S)this.readMap(typeToUse, dbo, parent);
        }
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(typeToUse);
        if (persistentEntity == null) {
            throw new MappingException("No mapping metadata found for " + rawType.getName());
        }
        return this.read(persistentEntity, dbo, parent);
    }

    private ParameterValueProvider<MongoPersistentProperty> getParameterProvider(MongoPersistentEntity<?> entity, DBObject source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(source, evaluator, parent);
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)provider, parent);
        parameterProvider.setSpELEvaluator((SpELExpressionEvaluator)evaluator);
        return parameterProvider;
    }

    private <S> S read(final MongoPersistentEntity<S> entity, final DBObject dbo, Object parent) {
        final DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)dbo, this.spELContext);
        ParameterValueProvider<MongoPersistentProperty> provider = this.getParameterProvider(entity, dbo, evaluator, parent);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.conversionService);
        final Object result = wrapper.getBean();
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                boolean isConstructorProperty = entity.isConstructorArgument(prop);
                boolean hasValueForProperty = dbo.containsField(prop.getFieldName());
                if (!hasValueForProperty || isConstructorProperty) {
                    return;
                }
                Object obj = MappingMongoConverter.this.getValueInternal(prop, dbo, (SpELExpressionEvaluator)evaluator, result);
                wrapper.setProperty((PersistentProperty)prop, obj, MappingMongoConverter.this.useFieldAccessOnly);
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object obj = MappingMongoConverter.this.getValueInternal(inverseProp, dbo, (SpELExpressionEvaluator)evaluator, result);
                try {
                    wrapper.setProperty((PersistentProperty)inverseProp, obj);
                }
                catch (IllegalAccessException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MappingException(e.getMessage(), (Throwable)e);
                }
            }
        });
        return (S)result;
    }

    @Override
    public com.mongodb.DBRef toDBRef(Object object, MongoPersistentProperty referingProperty) {
        DBRef annotation = null;
        if (referingProperty != null) {
            annotation = referingProperty.getDBRef();
            Assert.isTrue((annotation != null ? 1 : 0) != 0, (String)"The referenced property has to be mapped with @DBRef!");
        }
        return this.createDBRef(object, annotation);
    }

    public void write(Object obj, DBObject dbo) {
        if (null == obj) {
            return;
        }
        boolean handledByCustomConverter = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class) != null;
        TypeInformation type = ClassTypeInformation.from(obj.getClass());
        if (!handledByCustomConverter && !(dbo instanceof BasicDBList)) {
            this.typeMapper.writeType(type, dbo);
        }
        this.writeInternal(obj, dbo, type);
    }

    protected void writeInternal(Object obj, DBObject dbo, TypeInformation<?> typeHint) {
        if (null == obj) {
            return;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(obj.getClass(), DBObject.class);
        if (customTarget != null) {
            DBObject result = (DBObject)this.conversionService.convert(obj, DBObject.class);
            dbo.putAll((BSONObject)result);
            return;
        }
        if (Map.class.isAssignableFrom(obj.getClass())) {
            this.writeMapInternal((Map)obj, dbo, ClassTypeInformation.MAP);
            return;
        }
        if (Collection.class.isAssignableFrom(obj.getClass())) {
            this.writeCollectionInternal((Collection)obj, ClassTypeInformation.LIST, (BasicDBList)dbo);
            return;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass());
        this.writeInternal(obj, dbo, entity);
        this.addCustomTypeKeyIfNecessary(typeHint, obj, dbo);
    }

    protected void writeInternal(Object obj, final DBObject dbo, MongoPersistentEntity<?> entity) {
        if (obj == null) {
            return;
        }
        if (null == entity) {
            throw new MappingException("No mapping metadata found for entity of type " + obj.getClass().getName());
        }
        final BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        final MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getIdProperty();
        if (!dbo.containsField("_id") && null != idProperty) {
            try {
                Object id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
                dbo.put("_id", this.idMapper.convertId(id));
            }
            catch (ConversionException ignored) {
                // empty catch block
            }
        }
        entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

            public void doWithPersistentProperty(MongoPersistentProperty prop) {
                if (prop.equals(idProperty)) {
                    return;
                }
                Object propertyObj = wrapper.getProperty((PersistentProperty)prop, prop.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                if (null != propertyObj) {
                    if (!MappingMongoConverter.this.conversions.isSimpleType(propertyObj.getClass())) {
                        MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, prop);
                    } else {
                        MappingMongoConverter.this.writeSimpleInternal(propertyObj, dbo, prop.getFieldName());
                    }
                }
            }
        });
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<MongoPersistentProperty>(){

            public void doWithAssociation(Association<MongoPersistentProperty> association) {
                Class type;
                MongoPersistentProperty inverseProp = (MongoPersistentProperty)association.getInverse();
                Object propertyObj = wrapper.getProperty((PersistentProperty)inverseProp, type = inverseProp.getType(), MappingMongoConverter.this.useFieldAccessOnly);
                if (null != propertyObj) {
                    MappingMongoConverter.this.writePropertyInternal(propertyObj, dbo, inverseProp);
                }
            }
        });
    }

    protected void writePropertyInternal(Object obj, DBObject dbo, MongoPersistentProperty prop) {
        com.mongodb.DBRef dbRefObj;
        if (obj == null) {
            return;
        }
        String name = prop.getFieldName();
        TypeInformation valueType = ClassTypeInformation.from(obj.getClass());
        TypeInformation type = prop.getTypeInformation();
        if (valueType.isCollectionLike()) {
            DBObject collectionInternal = this.createCollection(MappingMongoConverter.asCollection(obj), prop);
            dbo.put(name, (Object)collectionInternal);
            return;
        }
        if (valueType.isMap()) {
            BasicDBObject mapDbObj = new BasicDBObject();
            this.writeMapInternal((Map)obj, (DBObject)mapDbObj, type);
            dbo.put(name, (Object)mapDbObj);
            return;
        }
        if (prop.isDbReference() && null != (dbRefObj = this.createDBRef(obj, prop.getDBRef()))) {
            dbo.put(name, (Object)dbRefObj);
            return;
        }
        Class<?> basicTargetType = this.conversions.getCustomWriteTarget(obj.getClass(), null);
        if (basicTargetType != null) {
            dbo.put(name, this.conversionService.convert(obj, basicTargetType));
            return;
        }
        BasicDBObject propDbObj = new BasicDBObject();
        this.addCustomTypeKeyIfNecessary(type, obj, (DBObject)propDbObj);
        MongoPersistentEntity entity = this.isSubtype(prop.getType(), obj.getClass()) ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(obj.getClass()) : (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        this.writeInternal(obj, (DBObject)propDbObj, entity);
        dbo.put(name, (Object)propDbObj);
    }

    private boolean isSubtype(Class<?> left, Class<?> right) {
        return left.isAssignableFrom(right) && !left.equals(right);
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    protected DBObject createCollection(Collection<?> collection, MongoPersistentProperty property) {
        if (!property.isDbReference()) {
            return this.writeCollectionInternal(collection, property.getTypeInformation(), new BasicDBList());
        }
        BasicDBList dbList = new BasicDBList();
        for (Object element : collection) {
            if (element == null) continue;
            com.mongodb.DBRef dbRef = this.createDBRef(element, property.getDBRef());
            dbList.add((Object)dbRef);
        }
        return dbList;
    }

    private BasicDBList writeCollectionInternal(Collection<?> source, TypeInformation<?> type, BasicDBList sink) {
        TypeInformation componentType = type == null ? null : type.getComponentType();
        for (Object element : source) {
            Class<?> elementType;
            Class<?> clazz = elementType = element == null ? null : element.getClass();
            if (elementType == null || this.conversions.isSimpleType(elementType)) {
                sink.add(this.getPotentiallyConvertedSimpleWrite(element));
                continue;
            }
            if (element instanceof Collection || elementType.isArray()) {
                sink.add((Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(element), componentType, new BasicDBList()));
                continue;
            }
            BasicDBObject propDbObj = new BasicDBObject();
            this.writeInternal(element, (DBObject)propDbObj, componentType);
            sink.add((Object)propDbObj);
        }
        return sink;
    }

    protected DBObject writeMapInternal(Map<Object, Object> obj, DBObject dbo, TypeInformation<?> propertyType) {
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (this.conversions.isSimpleType(key.getClass())) {
                String simpleKey = this.potentiallyEscapeMapKey(key.toString());
                if (val == null || this.conversions.isSimpleType(val.getClass())) {
                    this.writeSimpleInternal(val, dbo, simpleKey);
                    continue;
                }
                if (val instanceof Collection || val.getClass().isArray()) {
                    dbo.put(simpleKey, (Object)this.writeCollectionInternal(MappingMongoConverter.asCollection(val), propertyType.getMapValueType(), new BasicDBList()));
                    continue;
                }
                BasicDBObject newDbo = new BasicDBObject();
                TypeInformation valueTypeInfo = propertyType.isMap() ? propertyType.getMapValueType() : ClassTypeInformation.OBJECT;
                this.writeInternal(val, (DBObject)newDbo, valueTypeInfo);
                dbo.put(simpleKey, (Object)newDbo);
                continue;
            }
            throw new MappingException("Cannot use a complex object as a key value.");
        }
        return dbo;
    }

    protected String potentiallyEscapeMapKey(String source) {
        if (!source.contains(".")) {
            return source;
        }
        if (this.mapKeyDotReplacement == null) {
            throw new MappingException(String.format("Map key %s contains dots but no replacement was configured! Make sure map keys don't contain dots in the first place or configure an appropriate replacement!", source));
        }
        return source.replaceAll("\\.", this.mapKeyDotReplacement);
    }

    protected String potentiallyUnescapeMapKey(String source) {
        return this.mapKeyDotReplacement == null ? source : source.replaceAll(this.mapKeyDotReplacement, "\\.");
    }

    protected void addCustomTypeKeyIfNecessary(TypeInformation<?> type, Object value, DBObject dbObject) {
        boolean notTheSameClass;
        TypeInformation actualType = type != null ? type.getActualType() : type;
        Class reference = actualType == null ? Object.class : actualType.getType();
        boolean bl = notTheSameClass = !value.getClass().equals(reference);
        if (notTheSameClass) {
            this.typeMapper.writeType(value.getClass(), dbObject);
        }
    }

    private void writeSimpleInternal(Object value, DBObject dbObject, String key) {
        dbObject.put(key, this.getPotentiallyConvertedSimpleWrite(value));
    }

    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> customTarget = this.conversions.getCustomWriteTarget(value.getClass(), null);
        if (customTarget != null) {
            return this.conversionService.convert(value, customTarget);
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    private Object getPotentiallyConvertedSimpleRead(Object value, Class<?> target) {
        if (value == null || target == null) {
            return value;
        }
        if (this.conversions.hasCustomReadTarget(value.getClass(), target)) {
            return this.conversionService.convert(value, target);
        }
        if (Enum.class.isAssignableFrom(target)) {
            return Enum.valueOf(target, value.toString());
        }
        return target.isAssignableFrom(value.getClass()) ? value : this.conversionService.convert(value, target);
    }

    protected com.mongodb.DBRef createDBRef(Object target, DBRef dbref) {
        Assert.notNull((Object)target);
        MongoPersistentEntity targetEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(target.getClass());
        if (null == targetEntity) {
            throw new MappingException("No mapping metadata found for " + target.getClass());
        }
        MongoPersistentProperty idProperty = (MongoPersistentProperty)targetEntity.getIdProperty();
        if (idProperty == null) {
            throw new MappingException("No id property found on class " + targetEntity.getType());
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
        Object id = wrapper.getProperty((PersistentProperty)idProperty, Object.class, this.useFieldAccessOnly);
        if (null == id) {
            throw new MappingException("Cannot create a reference to an object with a NULL id.");
        }
        DB db = this.mongoDbFactory.getDb();
        db = dbref != null && StringUtils.hasText((String)dbref.db()) ? this.mongoDbFactory.getDb(dbref.db()) : db;
        return new com.mongodb.DBRef(db, targetEntity.getCollection(), this.idMapper.convertId(id));
    }

    protected Object getValueInternal(MongoPersistentProperty prop, DBObject dbo, SpELExpressionEvaluator eval, Object parent) {
        MongoDbPropertyValueProvider provider = new MongoDbPropertyValueProvider(dbo, this.spELContext, parent);
        return provider.getPropertyValue(prop);
    }

    private Object readCollectionOrArray(TypeInformation<?> targetType, BasicDBList sourceValue, Object parent) {
        Assert.notNull(targetType);
        if (sourceValue.isEmpty()) {
            return new HashSet();
        }
        Class<List> collectionType = targetType.getType();
        collectionType = Collection.class.isAssignableFrom(collectionType) ? collectionType : List.class;
        Collection<Object> items = targetType.getType().isArray() ? new ArrayList() : CollectionFactory.createCollection(collectionType, (int)sourceValue.size());
        TypeInformation componentType = targetType.getComponentType();
        Class rawComponentType = componentType == null ? null : componentType.getType();
        for (int i = 0; i < sourceValue.size(); ++i) {
            Object dbObjItem = sourceValue.get(i);
            if (dbObjItem instanceof com.mongodb.DBRef) {
                items.add(com.mongodb.DBRef.class.equals((Object)rawComponentType) ? dbObjItem : this.read(componentType, ((com.mongodb.DBRef)dbObjItem).fetch(), parent));
                continue;
            }
            if (dbObjItem instanceof DBObject) {
                items.add(this.read(componentType, (DBObject)dbObjItem, parent));
                continue;
            }
            items.add(this.getPotentiallyConvertedSimpleRead(dbObjItem, rawComponentType));
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType.getType());
    }

    protected Map<Object, Object> readMap(TypeInformation<?> type, DBObject dbObject, Object parent) {
        Assert.notNull((Object)dbObject);
        Class mapType = this.typeMapper.readType(dbObject, type).getType();
        Map map = CollectionFactory.createMap((Class)mapType, (int)dbObject.keySet().size());
        Map sourceMap = dbObject.toMap();
        for (Map.Entry entry : sourceMap.entrySet()) {
            Class rawValueType;
            if (this.typeMapper.isTypeKey((String)entry.getKey())) continue;
            Object key = this.potentiallyUnescapeMapKey((String)entry.getKey());
            TypeInformation keyTypeInformation = type.getComponentType();
            if (keyTypeInformation != null) {
                Class keyType = keyTypeInformation.getType();
                key = this.conversionService.convert(key, keyType);
            }
            Object value = entry.getValue();
            TypeInformation valueType = type.getMapValueType();
            Class clazz = rawValueType = valueType == null ? null : valueType.getType();
            if (value instanceof DBObject) {
                map.put(key, this.read(valueType, (DBObject)value, parent));
                continue;
            }
            if (value instanceof com.mongodb.DBRef) {
                map.put(key, com.mongodb.DBRef.class.equals((Object)rawValueType) ? value : this.read(valueType, ((com.mongodb.DBRef)value).fetch()));
                continue;
            }
            Class valueClass = valueType == null ? null : valueType.getType();
            map.put(key, this.getPotentiallyConvertedSimpleRead(value, valueClass));
        }
        return map;
    }

    protected <T> List<?> unwrapList(BasicDBList dbList, TypeInformation<T> targetType) {
        ArrayList<Object> rootList = new ArrayList<Object>();
        for (int i = 0; i < dbList.size(); ++i) {
            Object obj = dbList.get(i);
            if (obj instanceof BasicDBList) {
                rootList.add(this.unwrapList((BasicDBList)obj, targetType.getComponentType()));
                continue;
            }
            if (obj instanceof DBObject) {
                rootList.add(this.read(targetType, (DBObject)obj));
                continue;
            }
            rootList.add(obj);
        }
        return rootList;
    }

    @Override
    public Object convertToMongoType(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> target = this.conversions.getCustomWriteTarget(obj.getClass());
        if (target != null) {
            return this.conversionService.convert(obj, target);
        }
        if (null != obj && this.conversions.isSimpleType(obj.getClass())) {
            return this.getPotentiallyConvertedSimpleWrite(obj);
        }
        if (obj instanceof BasicDBList) {
            return this.maybeConvertList((Iterable<?>)((BasicDBList)obj));
        }
        if (obj instanceof DBObject) {
            BasicDBObject newValueDbo = new BasicDBObject();
            for (String vk : ((DBObject)obj).keySet()) {
                Object o = ((DBObject)obj).get(vk);
                newValueDbo.put(vk, this.convertToMongoType(o));
            }
            return newValueDbo;
        }
        if (obj instanceof Map) {
            BasicDBObject result = new BasicDBObject();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                result.put(entry.getKey().toString(), this.convertToMongoType(entry.getValue()));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            return this.maybeConvertList(Arrays.asList((Object[])obj));
        }
        if (obj instanceof Collection) {
            return this.maybeConvertList((Collection)obj);
        }
        BasicDBObject newDbo = new BasicDBObject();
        this.write(obj, (DBObject)newDbo);
        return this.removeTypeInfoRecursively(newDbo);
    }

    public BasicDBList maybeConvertList(Iterable<?> source) {
        BasicDBList newDbl = new BasicDBList();
        for (Object element : source) {
            newDbl.add(this.convertToMongoType(element));
        }
        return newDbl;
    }

    private Object removeTypeInfoRecursively(Object object) {
        if (!(object instanceof DBObject)) {
            return object;
        }
        DBObject dbObject = (DBObject)object;
        String keyToRemove = null;
        for (String key : dbObject.keySet()) {
            Object value;
            if (this.typeMapper.isTypeKey(key)) {
                keyToRemove = key;
            }
            if ((value = dbObject.get(key)) instanceof BasicDBList) {
                for (Object element : (BasicDBList)value) {
                    this.removeTypeInfoRecursively(element);
                }
                continue;
            }
            this.removeTypeInfoRecursively(value);
        }
        if (keyToRemove != null) {
            dbObject.removeField(keyToRemove);
        }
        return dbObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MongoDbPropertyValueProvider
    implements PropertyValueProvider<MongoPersistentProperty> {
        private final DBObject source;
        private final SpELExpressionEvaluator evaluator;
        private final Object parent;

        public MongoDbPropertyValueProvider(DBObject source, SpELContext factory, Object parent) {
            this(source, new DefaultSpELExpressionEvaluator((Object)source, factory), parent);
        }

        public MongoDbPropertyValueProvider(DBObject source, DefaultSpELExpressionEvaluator evaluator, Object parent) {
            Assert.notNull((Object)source);
            Assert.notNull((Object)evaluator);
            this.source = source;
            this.evaluator = evaluator;
            this.parent = parent;
        }

        public <T> T getPropertyValue(MongoPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.source.get(property.getFieldName());
            if (value == null) {
                return null;
            }
            TypeInformation type = property.getTypeInformation();
            Class rawType = type.getType();
            if (MappingMongoConverter.this.conversions.hasCustomReadTarget(value.getClass(), rawType)) {
                return (T)MappingMongoConverter.this.conversionService.convert(value, rawType);
            }
            if (value instanceof com.mongodb.DBRef) {
                return (T)(rawType.equals(com.mongodb.DBRef.class) ? value : MappingMongoConverter.this.read(type, ((com.mongodb.DBRef)value).fetch(), this.parent));
            }
            if (value instanceof BasicDBList) {
                return (T)MappingMongoConverter.this.readCollectionOrArray(type, (BasicDBList)value, this.parent);
            }
            if (value instanceof DBObject) {
                return (T)MappingMongoConverter.this.read(type, (DBObject)value, this.parent);
            }
            return (T)MappingMongoConverter.this.getPotentiallyConvertedSimpleRead(value, rawType);
        }
    }
}

