/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.beans.PropertyDescriptor;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.DBRef;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMongoPersistentProperty
extends AnnotationBasedPersistentProperty<MongoPersistentProperty>
implements MongoPersistentProperty {
    private static final Logger LOG = LoggerFactory.getLogger(BasicMongoPersistentProperty.class);
    private static final String ID_FIELD_NAME = "_id";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet();
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>();

    public BasicMongoPersistentProperty(java.lang.reflect.Field field, PropertyDescriptor propertyDescriptor, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
        if (this.isIdProperty() && this.getFieldName() != ID_FIELD_NAME) {
            LOG.warn("Customizing field name for id property not allowed! Custom name will not be considered!");
        }
    }

    public boolean isAssociation() {
        return this.field.isAnnotationPresent(DBRef.class) || super.isAssociation();
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.field.getName());
    }

    @Override
    public String getFieldName() {
        if (this.isIdProperty()) {
            return ID_FIELD_NAME;
        }
        Field annotation = this.getField().getAnnotation(Field.class);
        return annotation != null && StringUtils.hasText((String)annotation.value()) ? annotation.value() : this.field.getName();
    }

    @Override
    public int getFieldOrder() {
        Field annotation = this.getField().getAnnotation(Field.class);
        return annotation != null ? annotation.order() : Integer.MAX_VALUE;
    }

    protected Association<MongoPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public boolean isDbReference() {
        return this.getField().isAnnotationPresent(DBRef.class);
    }

    @Override
    public DBRef getDBRef() {
        return this.getField().getAnnotation(DBRef.class);
    }

    static {
        SUPPORTED_ID_TYPES.add(ObjectId.class);
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(BigInteger.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
        SUPPORTED_ID_PROPERTY_NAMES.add(ID_FIELD_NAME);
    }
}

