/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.geo.Distance;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingParameterAccessor
implements MongoParameterAccessor {
    private final MongoWriter<?> writer;
    private final MongoParameterAccessor delegate;

    public ConvertingParameterAccessor(MongoWriter<?> writer, MongoParameterAccessor delegate) {
        Assert.notNull(writer);
        Assert.notNull((Object)delegate);
        this.writer = writer;
        this.delegate = delegate;
    }

    public PotentiallyConvertingIterator iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index));
    }

    @Override
    public Distance getMaxDistance() {
        return this.delegate.getMaxDistance();
    }

    @Override
    public Point getGeoNearLocation() {
        return this.delegate.getGeoNearLocation();
    }

    private Object getConvertedValue(Object value) {
        return this.writer.convertToMongoType(value);
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public Object nextConverted(MongoPersistentProperty var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;

        public ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Object next() {
            return this.delegate.next();
        }

        @Override
        public Object nextConverted(MongoPersistentProperty property) {
            return property.isAssociation() ? ConvertingParameterAccessor.this.writer.toDBRef(this.next(), property) : ConvertingParameterAccessor.this.getConvertedValue(this.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

