/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.EntityInformationCreator;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityInformationCreator
implements EntityInformationCreator {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public DefaultEntityInformationCreator(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        Assert.notNull(mappingContext);
        this.mappingContext = mappingContext;
    }

    @Override
    public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    @Override
    public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, Class<?> collectionClass) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(domainClass);
        String customCollectionName = collectionClass == null ? null : ((MongoPersistentEntity)this.mappingContext.getPersistentEntity(collectionClass)).getCollection();
        return new MappingMongoEntityInformation(persistentEntity, customCollectionName);
    }
}

