/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class UnsetOperation
implements FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation {
    private final Collection<Object> fields;

    public UnsetOperation(Collection<Object> fields) {
        Assert.notNull(fields, (String)"Fields must not be null!");
        Assert.noNullElements(fields, (String)"Fields must not contain null values.");
        this.fields = fields;
    }

    public static UnsetOperation unset(String ... fields) {
        return new UnsetOperation(Arrays.asList(fields));
    }

    public UnsetOperation and(String ... fields) {
        ArrayList<Object> target = new ArrayList<Object>(this.fields);
        CollectionUtils.mergeArrayIntoCollection((Object)fields, target);
        return new UnsetOperation(target);
    }

    public UnsetOperation and(Field ... fields) {
        ArrayList<Object> target = new ArrayList<Object>(this.fields);
        CollectionUtils.mergeArrayIntoCollection((Object)fields, target);
        return new UnsetOperation(target);
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(new ExposedFields.ExposedField[0]);
    }

    Collection<String> removedFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.fields.size());
        for (Object it : this.fields) {
            if (it instanceof Field) {
                fieldNames.add(((Field)it).getName());
                continue;
            }
            fieldNames.add(it.toString());
        }
        return fieldNames;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        if (this.fields.size() == 1) {
            return new Document(this.getOperator(), this.computeFieldName(this.fields.iterator().next(), context));
        }
        return new Document(this.getOperator(), this.fields.stream().map(it -> this.computeFieldName(it, context)).collect(Collectors.toList()));
    }

    @Override
    public String getOperator() {
        return "$unset";
    }

    private Object computeFieldName(Object field, AggregationOperationContext context) {
        if (field instanceof Field) {
            return context.getReference((Field)field).getRaw();
        }
        if (field instanceof AggregationExpression) {
            return ((AggregationExpression)field).toDocument(context);
        }
        if (field instanceof String) {
            return context.getReference((String)field).getRaw();
        }
        return field;
    }
}

