/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.mapping.UnwrapEntityContext;
import org.springframework.data.mongodb.core.mapping.UnwrappedMongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.data.util.Streamable;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

class UnwrappedMongoPersistentEntity<T>
implements MongoPersistentEntity<T> {
    private final UnwrapEntityContext context;
    private final MongoPersistentEntity<T> delegate;

    public UnwrappedMongoPersistentEntity(MongoPersistentEntity<T> delegate, UnwrapEntityContext context) {
        this.context = context;
        this.delegate = delegate;
    }

    @Override
    public String getCollection() {
        return this.delegate.getCollection();
    }

    @Override
    public String getLanguage() {
        return this.delegate.getLanguage();
    }

    @Override
    @Nullable
    public MongoPersistentProperty getTextScoreProperty() {
        return this.delegate.getTextScoreProperty();
    }

    @Override
    public boolean hasTextScoreProperty() {
        return this.delegate.hasTextScoreProperty();
    }

    @Override
    @Nullable
    public Collation getCollation() {
        return this.delegate.getCollation();
    }

    @Override
    public boolean hasCollation() {
        return this.delegate.hasCollation();
    }

    @Override
    public ShardKey getShardKey() {
        return this.delegate.getShardKey();
    }

    @Override
    public boolean isSharded() {
        return this.delegate.isSharded();
    }

    public String getName() {
        return this.delegate.getName();
    }

    @Nullable
    @Deprecated
    public PreferredConstructor<T, MongoPersistentProperty> getPersistenceConstructor() {
        return this.delegate.getPersistenceConstructor();
    }

    public InstanceCreatorMetadata<MongoPersistentProperty> getInstanceCreatorMetadata() {
        return this.delegate.getInstanceCreatorMetadata();
    }

    public boolean isCreatorArgument(PersistentProperty<?> property) {
        return this.delegate.isCreatorArgument(property);
    }

    public boolean isIdProperty(PersistentProperty<?> property) {
        return this.delegate.isIdProperty(property);
    }

    public boolean isVersionProperty(PersistentProperty<?> property) {
        return this.delegate.isVersionProperty(property);
    }

    @Nullable
    public MongoPersistentProperty getIdProperty() {
        return (MongoPersistentProperty)this.delegate.getIdProperty();
    }

    public MongoPersistentProperty getRequiredIdProperty() {
        return (MongoPersistentProperty)this.delegate.getRequiredIdProperty();
    }

    @Nullable
    public MongoPersistentProperty getVersionProperty() {
        return (MongoPersistentProperty)this.delegate.getVersionProperty();
    }

    public MongoPersistentProperty getRequiredVersionProperty() {
        return (MongoPersistentProperty)this.delegate.getRequiredVersionProperty();
    }

    @Nullable
    public MongoPersistentProperty getPersistentProperty(String name) {
        return this.wrap((MongoPersistentProperty)this.delegate.getPersistentProperty(name));
    }

    public MongoPersistentProperty getRequiredPersistentProperty(String name) {
        MongoPersistentProperty persistentProperty = this.getPersistentProperty(name);
        if (persistentProperty != null) {
            return persistentProperty;
        }
        throw new IllegalStateException(String.format("Required property %s not found for %s", name, this.getType()));
    }

    @Nullable
    public MongoPersistentProperty getPersistentProperty(Class<? extends Annotation> annotationType) {
        return this.wrap((MongoPersistentProperty)this.delegate.getPersistentProperty(annotationType));
    }

    public Iterable<MongoPersistentProperty> getPersistentProperties(Class<? extends Annotation> annotationType) {
        return Streamable.of((Iterable)this.delegate.getPersistentProperties(annotationType)).stream().map(this::wrap).collect(Collectors.toList());
    }

    public boolean hasIdProperty() {
        return this.delegate.hasIdProperty();
    }

    public boolean hasVersionProperty() {
        return this.delegate.hasVersionProperty();
    }

    public Class<T> getType() {
        return this.delegate.getType();
    }

    public Alias getTypeAlias() {
        return this.delegate.getTypeAlias();
    }

    public TypeInformation<T> getTypeInformation() {
        return this.delegate.getTypeInformation();
    }

    public void doWithProperties(PropertyHandler<MongoPersistentProperty> handler) {
        this.delegate.doWithProperties(property -> handler.doWithPersistentProperty((PersistentProperty)this.wrap((MongoPersistentProperty)property)));
    }

    public void doWithProperties(SimplePropertyHandler handler) {
        this.delegate.doWithProperties(property -> {
            if (property instanceof MongoPersistentProperty) {
                handler.doWithPersistentProperty((PersistentProperty)this.wrap((MongoPersistentProperty)property));
            } else {
                handler.doWithPersistentProperty(property);
            }
        });
    }

    public void doWithAssociations(AssociationHandler<MongoPersistentProperty> handler) {
        this.delegate.doWithAssociations(handler);
    }

    public void doWithAssociations(SimpleAssociationHandler handler) {
        this.delegate.doWithAssociations(handler);
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return (A)this.delegate.findAnnotation(annotationType);
    }

    public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
        return (A)this.delegate.getRequiredAnnotation(annotationType);
    }

    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationType) {
        return this.delegate.isAnnotationPresent(annotationType);
    }

    public <B> PersistentPropertyAccessor<B> getPropertyAccessor(B bean) {
        return this.delegate.getPropertyAccessor(bean);
    }

    public <B> PersistentPropertyPathAccessor<B> getPropertyPathAccessor(B bean) {
        return this.delegate.getPropertyPathAccessor(bean);
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        return this.delegate.getIdentifierAccessor(bean);
    }

    public boolean isNew(Object bean) {
        return this.delegate.isNew(bean);
    }

    public boolean isImmutable() {
        return this.delegate.isImmutable();
    }

    public boolean requiresPropertyPopulation() {
        return this.delegate.requiresPropertyPopulation();
    }

    public Iterator<MongoPersistentProperty> iterator() {
        ArrayList target = new ArrayList();
        this.delegate.iterator().forEachRemaining(it -> target.add(this.wrap((MongoPersistentProperty)it)));
        return target.iterator();
    }

    public void forEach(Consumer<? super MongoPersistentProperty> action) {
        this.delegate.forEach(it -> action.accept(this.wrap((MongoPersistentProperty)it)));
    }

    public Spliterator<MongoPersistentProperty> spliterator() {
        return this.delegate.spliterator();
    }

    private MongoPersistentProperty wrap(MongoPersistentProperty source) {
        if (source == null) {
            return source;
        }
        return new UnwrappedMongoPersistentProperty(source, this.context);
    }

    public void addPersistentProperty(MongoPersistentProperty property) {
    }

    public void addAssociation(Association<MongoPersistentProperty> association) {
    }

    public void verify() throws MappingException {
    }

    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
    }

    public void setEvaluationContextProvider(EvaluationContextProvider provider) {
    }

    @Override
    public boolean isUnwrapped() {
        return this.context.getProperty().isUnwrapped();
    }

    @Override
    public Collection<Object> getEncryptionKeyIds() {
        return this.delegate.getEncryptionKeyIds();
    }
}

