/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class DefaultMongoTypeMapper
extends DefaultTypeMapper<Bson>
implements MongoTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private static final TypeInformation<List> LIST_TYPE_INFO = TypeInformation.of(List.class);
    private static final TypeInformation<Map> MAP_TYPE_INFO = TypeInformation.MAP;
    private final TypeAliasAccessor<Bson> accessor;
    @Nullable
    private final String typeKey;
    private UnaryOperator<Class<?>> writeTarget = UnaryOperator.identity();

    public DefaultMongoTypeMapper() {
        this(DEFAULT_TYPE_KEY);
    }

    public DefaultMongoTypeMapper(@Nullable String typeKey) {
        this(typeKey, Collections.singletonList(new SimpleTypeInformationMapper()));
    }

    public DefaultMongoTypeMapper(@Nullable String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        this(typeKey, new DocumentTypeAliasAccessor(typeKey), mappingContext, Collections.singletonList(new SimpleTypeInformationMapper()));
    }

    public DefaultMongoTypeMapper(@Nullable String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, UnaryOperator<Class<?>> writeTarget) {
        this(typeKey, new DocumentTypeAliasAccessor(typeKey), mappingContext, Collections.singletonList(new SimpleTypeInformationMapper()));
        this.writeTarget = writeTarget;
    }

    public DefaultMongoTypeMapper(@Nullable String typeKey, List<? extends TypeInformationMapper> mappers) {
        this(typeKey, new DocumentTypeAliasAccessor(typeKey), null, mappers);
    }

    private DefaultMongoTypeMapper(@Nullable String typeKey, TypeAliasAccessor<Bson> accessor, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext, List<? extends TypeInformationMapper> mappers) {
        super(accessor, mappingContext, mappers);
        this.typeKey = typeKey;
        this.accessor = accessor;
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    @Override
    public void writeTypeRestrictions(Document result, @Nullable Set<Class<?>> restrictedTypes) {
        if (ObjectUtils.isEmpty(restrictedTypes)) {
            return;
        }
        BasicDBList restrictedMappedTypes = new BasicDBList();
        for (Class<?> restrictedType : restrictedTypes) {
            Alias typeAlias = this.getAliasFor(TypeInformation.of(restrictedType));
            if (ObjectUtils.nullSafeEquals((Object)Alias.NONE, (Object)typeAlias) || !typeAlias.isPresent()) continue;
            restrictedMappedTypes.add(typeAlias.getValue());
        }
        this.accessor.writeTypeTo((Object)result, (Object)new Document("$in", (Object)restrictedMappedTypes));
    }

    @Override
    public Class<?> getWriteTargetTypeFor(Class<?> source) {
        return (Class)this.writeTarget.apply(source);
    }

    protected TypeInformation<?> getFallbackTypeFor(Bson source) {
        return source instanceof BasicDBList ? LIST_TYPE_INFO : MAP_TYPE_INFO;
    }

    public static final class DocumentTypeAliasAccessor
    implements TypeAliasAccessor<Bson> {
        @Nullable
        private final String typeKey;

        public DocumentTypeAliasAccessor(@Nullable String typeKey) {
            this.typeKey = typeKey;
        }

        public Alias readAliasFrom(Bson source) {
            if (source instanceof List) {
                return Alias.NONE;
            }
            if (source instanceof Document) {
                Document document = (Document)source;
                return Alias.ofNullable((Object)document.get((Object)this.typeKey));
            }
            if (source instanceof DBObject) {
                DBObject dbObject = (DBObject)source;
                return Alias.ofNullable((Object)dbObject.get(this.typeKey));
            }
            throw new IllegalArgumentException("Cannot read alias from " + source.getClass());
        }

        public void writeTypeTo(Bson sink, Object alias) {
            if (this.typeKey != null) {
                if (sink instanceof Document) {
                    Document document = (Document)sink;
                    document.put(this.typeKey, alias);
                } else if (sink instanceof DBObject) {
                    DBObject dbObject = (DBObject)sink;
                    dbObject.put(this.typeKey, alias);
                }
            }
        }
    }
}

