/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import org.bson.conversions.Bson;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class MongoConversionContext
implements ValueConversionContext<MongoPersistentProperty> {
    private final PropertyValueProvider<MongoPersistentProperty> accessor;
    private final MongoPersistentProperty persistentProperty;
    private final MongoConverter mongoConverter;
    @Nullable
    private final SpELContext spELContext;

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, MongoPersistentProperty persistentProperty, MongoConverter mongoConverter) {
        this(accessor, persistentProperty, mongoConverter, null);
    }

    public MongoConversionContext(PropertyValueProvider<MongoPersistentProperty> accessor, MongoPersistentProperty persistentProperty, MongoConverter mongoConverter, @Nullable SpELContext spELContext) {
        this.accessor = accessor;
        this.persistentProperty = persistentProperty;
        this.mongoConverter = mongoConverter;
        this.spELContext = spELContext;
    }

    public MongoPersistentProperty getProperty() {
        return this.persistentProperty;
    }

    @Nullable
    public Object getValue(String propertyPath) {
        return this.accessor.getPropertyValue((PersistentProperty)((MongoPersistentProperty)this.persistentProperty.getOwner().getRequiredPersistentProperty(propertyPath)));
    }

    public <T> T write(@Nullable Object value, TypeInformation<T> target) {
        return (T)this.mongoConverter.convertToMongoType(value, target);
    }

    public <T> T read(@Nullable Object value, TypeInformation<T> target) {
        Object object;
        if (value instanceof Bson) {
            Bson bson = (Bson)value;
            object = this.mongoConverter.read(target.getType(), bson);
        } else {
            object = super.read(value, target);
        }
        return (T)object;
    }

    @Nullable
    public SpELContext getSpELContext() {
        return this.spELContext;
    }
}

