/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import graphql.ExecutionInput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.test.tester.AbstractDirectGraphQlTransport;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

final class GraphQlServiceGraphQlTransport
extends AbstractDirectGraphQlTransport {
    private final ExecutionGraphQlService graphQlService;
    private final List<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>> executionInputConfigurers;

    GraphQlServiceGraphQlTransport(ExecutionGraphQlService graphQlService, List<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>> executionInputConfigurers) {
        Assert.notNull((Object)graphQlService, (String)"GraphQlService is required");
        this.graphQlService = graphQlService;
        this.executionInputConfigurers = new ArrayList<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>>(executionInputConfigurers);
    }

    public ExecutionGraphQlService getGraphQlService() {
        return this.graphQlService;
    }

    public List<BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput>> getExecutionInputConfigurers() {
        return this.executionInputConfigurers;
    }

    @Override
    protected Mono<ExecutionGraphQlResponse> executeInternal(ExecutionGraphQlRequest request) {
        this.executionInputConfigurers.forEach(arg_0 -> ((ExecutionGraphQlRequest)request).configureExecutionInput(arg_0));
        return this.graphQlService.execute(request);
    }
}

