/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.KafkaMessageListenerContainer;
import org.springframework.util.Assert;

public class ConcurrentMessageListenerContainer<K, V>
extends AbstractMessageListenerContainer<K, V> {
    private final ConsumerFactory<K, V> consumerFactory;
    private final String[] topics;
    private final Pattern topicPattern;
    private final List<KafkaMessageListenerContainer<K, V>> containers = new ArrayList<KafkaMessageListenerContainer<K, V>>();
    private long recentOffset;
    private TopicPartition[] partitions;
    private int concurrency = 1;

    public ConcurrentMessageListenerContainer(ConsumerFactory<K, V> consumerFactory, TopicPartition ... topicPartitions) {
        Assert.notNull(consumerFactory, (String)"A ConsumerFactory must be provided");
        Assert.notEmpty((Object[])topicPartitions, (String)"A list of partitions must be provided");
        Assert.noNullElements((Object[])topicPartitions, (String)"The list of partitions cannot contain null elements");
        this.consumerFactory = consumerFactory;
        this.partitions = new LinkedHashSet<TopicPartition>(Arrays.asList(topicPartitions)).toArray(new TopicPartition[topicPartitions.length]);
        this.topics = null;
        this.topicPattern = null;
    }

    public ConcurrentMessageListenerContainer(ConsumerFactory<K, V> consumerFactory, String ... topics) {
        Assert.notNull(consumerFactory, (String)"A ConsumerFactory must be provided");
        Assert.notNull((Object)topics, (String)"A list of topics must be provided");
        Assert.noNullElements((Object[])topics, (String)"The list of topics cannot contain null elements");
        this.consumerFactory = consumerFactory;
        this.topics = Arrays.asList(topics).toArray(new String[topics.length]);
        this.topicPattern = null;
    }

    public ConcurrentMessageListenerContainer(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
        Assert.notNull(consumerFactory, (String)"A ConsumerFactory must be provided");
        Assert.notNull((Object)topicPattern, (String)"A topic pattern must be provided");
        this.consumerFactory = consumerFactory;
        this.topics = null;
        this.topicPattern = topicPattern;
    }

    public void setRecentOffset(long recentOffset) {
        this.recentOffset = recentOffset;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int concurrency) {
        Assert.isTrue((concurrency > 0 ? 1 : 0) != 0, (String)"concurrency must be greater than 0");
        this.concurrency = concurrency;
    }

    public List<KafkaMessageListenerContainer<K, V>> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    @Override
    protected void doStart() {
        if (!this.isRunning()) {
            if (this.partitions != null && this.concurrency > this.partitions.length) {
                this.logger.warn((Object)("When specific partitions are provided, the concurrency must be less than or equal to the number of partitions; reduced from " + this.concurrency + " to " + this.partitions.length));
                this.concurrency = this.partitions.length;
            }
            this.setRunning(true);
            for (int i = 0; i < this.concurrency; ++i) {
                KafkaMessageListenerContainer<K, V> container = this.partitions == null ? new KafkaMessageListenerContainer<K, V>(this.consumerFactory, this.topics, this.topicPattern, this.partitions) : new KafkaMessageListenerContainer<K, V>(this.consumerFactory, this.topics, this.topicPattern, this.partitionSubset(i));
                container.setAckMode(this.getAckMode());
                container.setAckCount(this.getAckCount());
                container.setAckTime(this.getAckTime());
                container.setRecentOffset(this.recentOffset);
                container.setAutoStartup(false);
                container.setMessageListener(this.getMessageListener());
                if (this.getTaskExecutor() != null) {
                    container.setTaskExecutor(this.getTaskExecutor());
                }
                if (this.getBeanName() != null) {
                    container.setBeanName(this.getBeanName() + "-" + i);
                }
                container.start();
                this.containers.add(container);
            }
        }
    }

    private TopicPartition[] partitionSubset(int i) {
        if (this.concurrency == 1) {
            return this.partitions;
        }
        int numPartitions = this.partitions.length;
        if (numPartitions == this.concurrency) {
            return new TopicPartition[]{this.partitions[i]};
        }
        int perContainer = numPartitions / this.concurrency;
        TopicPartition[] subset = i == this.concurrency - 1 ? Arrays.copyOfRange(this.partitions, i * perContainer, this.partitions.length) : Arrays.copyOfRange(this.partitions, i * perContainer, (i + 1) * perContainer);
        return subset;
    }

    @Override
    protected void doStop() {
        if (this.isRunning()) {
            this.setRunning(false);
            for (KafkaMessageListenerContainer<K, V> container : this.containers) {
                container.stop();
            }
            this.containers.clear();
        }
    }
}

