/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.KafkaHeaderMapper;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.PatternMatchUtils;

public class DefaultKafkaHeaderMapper
implements KafkaHeaderMapper {
    private static final Log logger = LogFactory.getLog(DefaultKafkaHeaderMapper.class);
    private static final List<String> DEFAULT_TRUSTED_PACKAGES = Arrays.asList("java.util", "java.lang");
    public static final String JSON_TYPES = "spring_json_header_types";
    private static final List<SimplePatternBasedHeaderMatcher> NEVER_MAPPED = Arrays.asList(new SimplePatternBasedHeaderMatcher("!kafka_acknowledgment"), new SimplePatternBasedHeaderMatcher("!kafka_consumer"), new SimplePatternBasedHeaderMatcher("!kafka_messageKey"), new SimplePatternBasedHeaderMatcher("!kafka_offset"), new SimplePatternBasedHeaderMatcher("!kafka_partitionId"), new SimplePatternBasedHeaderMatcher("!kafka_data"), new SimplePatternBasedHeaderMatcher("!kafka_receivedMessageKey"), new SimplePatternBasedHeaderMatcher("!kafka_receivedPartitionId"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTimestamp"), new SimplePatternBasedHeaderMatcher("!kafka_receivedTopic"), new SimplePatternBasedHeaderMatcher("!kafka_timestamp"), new SimplePatternBasedHeaderMatcher("!kafka_timestampType"), new SimplePatternBasedHeaderMatcher("!kafka_batchConvertedHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_nativeHeaders"), new SimplePatternBasedHeaderMatcher("!kafka_topic"));
    private final ObjectMapper objectMapper;
    private final List<SimplePatternBasedHeaderMatcher> matchers = new ArrayList<SimplePatternBasedHeaderMatcher>(NEVER_MAPPED);
    private final Set<String> trustedPackages = new LinkedHashSet<String>(DEFAULT_TRUSTED_PACKAGES);

    public DefaultKafkaHeaderMapper() {
        this(new ObjectMapper());
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper) {
        this(objectMapper, "!id", "!timestamp", "*");
    }

    public DefaultKafkaHeaderMapper(String ... patterns) {
        this(new ObjectMapper(), patterns);
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper, String ... patterns) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.notNull((Object)patterns, (String)"'patterns' must not be null");
        Assert.noNullElements((Object[])patterns, (String)"'patterns' must not have null elements");
        this.objectMapper = objectMapper;
        for (String pattern : patterns) {
            this.matchers.add(new SimplePatternBasedHeaderMatcher(pattern));
        }
    }

    public void addTrustedPackages(String ... trustedPackages) {
        if (trustedPackages != null) {
            for (String whiteList : trustedPackages) {
                if ("*".equals(whiteList)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(whiteList);
            }
        }
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        HashMap jsonHeaders = new HashMap();
        headers.forEach((k, v) -> {
            block5: {
                if (this.matches((String)k)) {
                    if (v instanceof byte[]) {
                        target.add((Header)new RecordHeader(k, (byte[])v));
                    } else {
                        try {
                            target.add((Header)new RecordHeader(k, this.objectMapper.writeValueAsBytes(v)));
                            jsonHeaders.put(k, v.getClass().getName());
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) break block5;
                            logger.debug((Object)("Could not map " + k + " with type " + v.getClass().getName()));
                        }
                    }
                }
            }
        });
        if (jsonHeaders.size() > 0) {
            try {
                target.add((Header)new RecordHeader(JSON_TYPES, this.objectMapper.writeValueAsBytes(jsonHeaders)));
            }
            catch (JsonProcessingException | IllegalStateException e) {
                logger.error((Object)"Could not add json types header", e);
            }
        }
    }

    protected boolean matches(String header) {
        for (SimplePatternBasedHeaderMatcher matcher : this.matchers) {
            if (!matcher.matchHeader(header)) continue;
            return !matcher.isNegated();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL NOT be mapped; matched no patterns", header));
        }
        return false;
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> headers) {
        Map types = null;
        for (Header next : source) {
            if (!next.key().equals(JSON_TYPES)) continue;
            try {
                types = (Map)this.objectMapper.readValue(next.value(), HashMap.class);
            }
            catch (IOException e) {
                logger.error((Object)("Could not decode json types: " + new String(next.value())), (Throwable)e);
            }
            break;
        }
        Map jsonTypes = types;
        source.forEach(h -> {
            if (!h.key().equals(JSON_TYPES)) {
                if (jsonTypes != null && jsonTypes.containsKey(h.key())) {
                    Class type = Object.class;
                    String requestedType = (String)jsonTypes.get(h.key());
                    boolean trusted = false;
                    try {
                        trusted = this.trusted(requestedType);
                        if (trusted) {
                            type = ClassUtils.forName((String)requestedType, null);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Could not load class for header: " + h.key()), (Throwable)e);
                    }
                    if (trusted) {
                        try {
                            headers.put(h.key(), this.objectMapper.readValue(h.value(), type));
                        }
                        catch (IOException e) {
                            logger.error((Object)("Could not decode json type: " + new String(h.value()) + " for key: " + h.key()), (Throwable)e);
                            headers.put(h.key(), h.value());
                        }
                    } else {
                        headers.put(h.key(), new NonTrustedHeaderType(h.value(), requestedType));
                    }
                } else {
                    headers.put(h.key(), h.value());
                }
            }
        });
    }

    private boolean trusted(String requestedType) {
        if (!this.trustedPackages.isEmpty()) {
            int lastDot = requestedType.lastIndexOf(".");
            if (lastDot < 0) {
                return false;
            }
            String packageName = requestedType.substring(0, lastDot);
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class NonTrustedHeaderType {
        private final byte[] headerValue;
        private final String untrustedType;

        NonTrustedHeaderType(byte[] headerValue, String untrustedType) {
            this.headerValue = headerValue;
            this.untrustedType = untrustedType;
        }

        public byte[] getHeaderValue() {
            return this.headerValue;
        }

        public String getUntrustedType() {
            return this.untrustedType;
        }

        public String toString() {
            return "NonTrustedHeaderType [headerValue=" + Arrays.toString(this.headerValue) + ", untrustedType=" + this.untrustedType + "]";
        }
    }

    protected static class SimplePatternBasedHeaderMatcher {
        private static final Log logger = LogFactory.getLog(SimplePatternBasedHeaderMatcher.class);
        private final String pattern;
        private final boolean negate;

        public SimplePatternBasedHeaderMatcher(String pattern) {
            this(pattern.startsWith("!") ? pattern.substring(1) : pattern, pattern.startsWith("!"));
        }

        SimplePatternBasedHeaderMatcher(String pattern, boolean negate) {
            Assert.notNull((Object)pattern, (String)"Pattern must no be null");
            this.pattern = pattern.toLowerCase();
            this.negate = negate;
        }

        public boolean matchHeader(String headerName) {
            String header = headerName.toLowerCase();
            if (PatternMatchUtils.simpleMatch((String)this.pattern, (String)header)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("headerName=[{0}] WILL " + (this.negate ? "NOT " : "") + "be mapped, matched pattern=" + (this.negate ? "!" : "") + "{1}", headerName, this.pattern));
                }
                return true;
            }
            return false;
        }

        public boolean isNegated() {
            return this.negate;
        }
    }
}

