/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class JsonDeserializer<T>
implements Deserializer<T> {
    protected final ObjectMapper objectMapper;
    protected final Class<T> targetType;
    private volatile ObjectReader reader;

    protected JsonDeserializer() {
        this((Class)null);
    }

    protected JsonDeserializer(ObjectMapper objectMapper) {
        this(null, objectMapper);
    }

    public JsonDeserializer(Class<T> targetType) {
        this(targetType, new ObjectMapper());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JsonDeserializer(Class<T> targetType, ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        if (targetType == null) {
            targetType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
        }
        Assert.notNull(targetType, (String)"'targetType' cannot be resolved.");
        this.targetType = targetType;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public T deserialize(String topic, byte[] data) {
        if (this.reader == null) {
            this.reader = this.objectMapper.readerFor(this.targetType);
        }
        try {
            Object result = null;
            if (data != null) {
                result = this.reader.readValue(data);
            }
            return (T)result;
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public void close() {
    }
}

