/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.Assert;

public class KafkaStreamsConfiguration {
    private final Map<String, Object> configs;
    private Properties properties;

    public KafkaStreamsConfiguration(Map<String, Object> configs) {
        Assert.notNull(configs, (String)"Configuration map cannot be null");
        this.configs = new HashMap<String, Object>(configs);
    }

    public Properties asProperties() {
        if (this.properties == null) {
            Properties properties = new Properties();
            this.configs.forEach((k, v) -> {
                String value = v.toString();
                if (v instanceof List && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                properties.setProperty((String)k, value);
            });
            this.properties = properties;
        }
        return this.properties;
    }
}

