/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;

public class SeekToCurrentErrorHandler
implements ContainerAwareErrorHandler {
    private static final Log logger = LogFactory.getLog(SeekToCurrentErrorHandler.class);
    private final FailedRecordTracker failureTracker;

    public SeekToCurrentErrorHandler() {
        this(null, 10);
    }

    public SeekToCurrentErrorHandler(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, 10);
    }

    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        this.failureTracker = new FailedRecordTracker(recoverer, maxFailures, logger);
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        SeekUtils.doSeeks(records, consumer, thrownException, true, this.failureTracker::skip, logger);
        throw new KafkaException("Seek to current after exception", thrownException);
    }

    @Override
    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

