/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ExtendedDeserializer;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.converter.AbstractJavaTypeMapper;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class JsonDeserializer<T>
implements ExtendedDeserializer<T> {
    @Deprecated
    public static final String DEFAULT_KEY_TYPE = "spring.json.key.default.type";
    @Deprecated
    public static final String DEFAULT_VALUE_TYPE = "spring.json.default.value.type";
    public static final String KEY_DEFAULT_TYPE = "spring.json.key.default.type";
    public static final String VALUE_DEFAULT_TYPE = "spring.json.value.default.type";
    public static final String TRUSTED_PACKAGES = "spring.json.trusted.packages";
    public static final String TYPE_MAPPINGS = "spring.json.type.mapping";
    protected final ObjectMapper objectMapper;
    protected Class<T> targetType;
    private volatile ObjectReader reader;
    protected Jackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
    private boolean typeMapperExplicitlySet = false;

    public JsonDeserializer() {
        this(null, true);
    }

    public JsonDeserializer(ObjectMapper objectMapper) {
        this(null, objectMapper, true);
    }

    public JsonDeserializer(Class<T> targetType) {
        this(targetType, true);
    }

    public JsonDeserializer(Class<T> targetType, boolean useHeadersIfPresent) {
        this(targetType, new ObjectMapper(), useHeadersIfPresent);
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public JsonDeserializer(Class<T> targetType, ObjectMapper objectMapper) {
        this(targetType, objectMapper, true);
    }

    public JsonDeserializer(@Nullable Class<T> targetType, ObjectMapper objectMapper, boolean useHeadersIfPresent) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
        this.targetType = targetType;
        if (this.targetType == null) {
            this.targetType = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0});
        }
        Assert.isTrue((this.targetType != null || useHeadersIfPresent ? 1 : 0) != 0, (String)"'targetType' cannot be null if 'useHeadersIfPresent' is false");
        if (this.targetType != null) {
            this.reader = this.objectMapper.readerFor(this.targetType);
        }
        this.addTargetPackageToTrusted();
        this.typeMapper.setTypePrecedence(useHeadersIfPresent ? Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID : Jackson2JavaTypeMapper.TypePrecedence.INFERRED);
    }

    public Jackson2JavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(Jackson2JavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
        this.typeMapperExplicitlySet = true;
    }

    public void setUseTypeMapperForKey(boolean isKey) {
        if (!this.typeMapperExplicitlySet && this.getTypeMapper() instanceof AbstractJavaTypeMapper) {
            AbstractJavaTypeMapper typeMapper = (AbstractJavaTypeMapper)((Object)this.getTypeMapper());
            typeMapper.setUseForKey(isKey);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.setUseTypeMapperForKey(isKey);
        try {
            if (isKey && configs.containsKey("spring.json.key.default.type")) {
                if (configs.get("spring.json.key.default.type") instanceof Class) {
                    this.targetType = (Class)configs.get("spring.json.key.default.type");
                } else {
                    if (!(configs.get("spring.json.key.default.type") instanceof String)) throw new IllegalStateException("spring.json.key.default.type must be Class or String");
                    this.targetType = ClassUtils.forName((String)((String)configs.get("spring.json.key.default.type")), null);
                }
            } else if (!isKey && configs.containsKey(DEFAULT_VALUE_TYPE)) {
                if (configs.get(DEFAULT_VALUE_TYPE) instanceof Class) {
                    this.targetType = (Class)configs.get(DEFAULT_VALUE_TYPE);
                } else {
                    if (!(configs.get(DEFAULT_VALUE_TYPE) instanceof String)) throw new IllegalStateException("spring.json.default.value.type must be Class or String");
                    this.targetType = ClassUtils.forName((String)((String)configs.get(DEFAULT_VALUE_TYPE)), null);
                }
            } else if (!isKey && configs.containsKey(VALUE_DEFAULT_TYPE)) {
                if (configs.get(VALUE_DEFAULT_TYPE) instanceof Class) {
                    this.targetType = (Class)configs.get(VALUE_DEFAULT_TYPE);
                } else {
                    if (!(configs.get(VALUE_DEFAULT_TYPE) instanceof String)) throw new IllegalStateException("spring.json.value.default.type must be Class or String");
                    this.targetType = ClassUtils.forName((String)((String)configs.get(VALUE_DEFAULT_TYPE)), null);
                }
            }
            if (this.targetType != null) {
                this.reader = this.objectMapper.readerFor(this.targetType);
            }
            this.addTargetPackageToTrusted();
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalStateException(e);
        }
        if (configs.containsKey(TRUSTED_PACKAGES) && configs.get(TRUSTED_PACKAGES) instanceof String) {
            this.typeMapper.addTrustedPackages(StringUtils.commaDelimitedListToStringArray((String)((String)configs.get(TRUSTED_PACKAGES))));
        }
        if (!configs.containsKey(TYPE_MAPPINGS) || this.typeMapperExplicitlySet || !(this.typeMapper instanceof AbstractJavaTypeMapper)) return;
        ((AbstractJavaTypeMapper)((Object)this.typeMapper)).setIdClassMapping(JsonSerializer.createMappings((String)configs.get(TYPE_MAPPINGS)));
    }

    public void addTrustedPackages(String ... packages) {
        this.typeMapper.addTrustedPackages(packages);
    }

    private void addTargetPackageToTrusted() {
        if (this.targetType != null) {
            this.addTrustedPackages(this.targetType.getPackage().getName());
        }
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        JavaType javaType;
        if (data == null) {
            return null;
        }
        ObjectReader reader = null;
        if (this.typeMapper.getTypePrecedence().equals((Object)Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID) && (javaType = this.typeMapper.toJavaType(headers)) != null) {
            reader = this.objectMapper.readerFor(javaType);
        }
        if (reader == null) {
            reader = this.reader;
        }
        Assert.state((reader != null ? 1 : 0) != 0, (String)"No type information in headers and no default type provided");
        try {
            return (T)reader.readValue(data);
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        Assert.state((this.reader != null ? 1 : 0) != 0, (String)"No headers available and no default type provided");
        try {
            Object result = null;
            if (data != null) {
                result = this.reader.readValue(data);
            }
            return (T)result;
        }
        catch (IOException e) {
            throw new SerializationException("Can't deserialize data [" + Arrays.toString(data) + "] from topic [" + topic + "]", (Throwable)e);
        }
    }

    public void close() {
    }
}

