/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.transaction;

import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.transaction.KafkaAwareTransactionManager;
import org.springframework.kafka.transaction.KafkaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class ChainedKafkaTransactionManager<K, V>
extends ChainedTransactionManager
implements KafkaAwareTransactionManager<K, V> {
    private final KafkaAwareTransactionManager<K, V> kafkaTransactionManager;

    public ChainedKafkaTransactionManager(PlatformTransactionManager ... transactionManagers) {
        super(transactionManagers);
        KafkaTransactionManager kafkaTransactionManager = null;
        for (PlatformTransactionManager tm : transactionManagers) {
            if (!(tm instanceof KafkaAwareTransactionManager)) continue;
            Assert.isNull(kafkaTransactionManager, (String)"Only one KafkaAwareTransactionManager is allowed");
            kafkaTransactionManager = (KafkaTransactionManager)tm;
        }
        Assert.notNull(kafkaTransactionManager, (String)"Exactly one KafkaAwareTransactionManager is required");
        this.kafkaTransactionManager = kafkaTransactionManager;
    }

    @Override
    public ProducerFactory<K, V> getProducerFactory() {
        return this.kafkaTransactionManager.getProducerFactory();
    }

    @Deprecated
    public Object getResourceFactory() {
        return this.getProducerFactory();
    }
}

