/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;

public class DefaultAfterRollbackProcessor<K, V>
implements AfterRollbackProcessor<K, V> {
    private static final Log logger = LogFactory.getLog(DefaultAfterRollbackProcessor.class);
    private final FailedRecordTracker failureTracker;

    public DefaultAfterRollbackProcessor() {
        this(null, 10);
    }

    public DefaultAfterRollbackProcessor(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, 10);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        this.failureTracker = new FailedRecordTracker(recoverer, maxFailures, logger);
    }

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer, Exception exception, boolean recoverable) {
        SeekUtils.doSeeks(records, consumer, exception, recoverable, this.failureTracker::skip, logger);
    }

    @Override
    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

